/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ShowTablesHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;

public class SqlShowTables
extends DrillSqlCall {
    private final SqlIdentifier db;
    private final SqlNode likePattern;
    private final SqlNode whereClause;
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW_TABLES", SqlKind.OTHER){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlShowTables(pos, (SqlIdentifier)operands[0], operands[1], operands[2]);
        }
    };

    public SqlShowTables(SqlParserPos pos, SqlIdentifier db, SqlNode likePattern, SqlNode whereClause) {
        super(pos);
        this.db = db;
        this.likePattern = likePattern;
        this.whereClause = whereClause;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> opList = Lists.newArrayList();
        opList.add(this.db);
        opList.add(this.likePattern);
        opList.add(this.whereClause);
        return opList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SHOW");
        writer.keyword("TABLES");
        if (this.db != null) {
            this.db.unparse(writer, leftPrec, rightPrec);
        }
        if (this.likePattern != null) {
            writer.keyword("LIKE");
            this.likePattern.unparse(writer, leftPrec, rightPrec);
        }
        if (this.whereClause != null) {
            this.whereClause.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new ShowTablesHandler(config);
    }

    public SqlIdentifier getDb() {
        return this.db;
    }

    public SqlNode getLikePattern() {
        return this.likePattern;
    }

    public SqlNode getWhereClause() {
        return this.whereClause;
    }
}

