/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DescribeTableHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;

public class SqlDescribeTable
extends DrillSqlCall {
    private final SqlIdentifier table;
    private final SqlIdentifier column;
    private final SqlNode columnQualifier;
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DESCRIBE_TABLE", SqlKind.OTHER){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDescribeTable(pos, (SqlIdentifier)operands[0], (SqlIdentifier)operands[1], operands[2]);
        }
    };

    public SqlDescribeTable(SqlParserPos pos, SqlIdentifier table, SqlIdentifier column, SqlNode columnQualifier) {
        super(pos);
        this.table = table;
        this.column = column;
        this.columnQualifier = columnQualifier;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> opList = Lists.newArrayList();
        opList.add(this.table);
        opList.add(this.column);
        opList.add(this.columnQualifier);
        return opList;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DESCRIBE");
        writer.keyword("TABLE");
        this.table.unparse(writer, leftPrec, rightPrec);
        if (this.column != null) {
            this.column.unparse(writer, leftPrec, rightPrec);
        }
        if (this.columnQualifier != null) {
            this.columnQualifier.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new DescribeTableHandler(config);
    }

    public SqlIdentifier getTable() {
        return this.table;
    }

    public SqlIdentifier getColumn() {
        return this.column;
    }

    public SqlNode getColumnQualifier() {
        return this.columnQualifier;
    }
}

