/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.CreateTableHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;

public class SqlCreateTable
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_TABLE", SqlKind.OTHER){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlCreateTable(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], operands[2]);
        }
    };
    private SqlIdentifier tblName;
    private SqlNodeList fieldList;
    private SqlNode query;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tblName, SqlNodeList fieldList, SqlNode query) {
        super(pos);
        this.tblName = tblName;
        this.fieldList = fieldList;
        this.query = query;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = Lists.newArrayList();
        ops.add(this.tblName);
        ops.add(this.fieldList);
        ops.add(this.query);
        return ops;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        this.tblName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList != null && this.fieldList.size() > 0) {
            writer.keyword("(");
            this.fieldList.get(0).unparse(writer, leftPrec, rightPrec);
            for (int i = 1; i < this.fieldList.size(); ++i) {
                writer.keyword(",");
                this.fieldList.get(i).unparse(writer, leftPrec, rightPrec);
            }
            writer.keyword(")");
        }
        writer.keyword("AS");
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(SqlHandlerConfig config) {
        return new CreateTableHandler(config);
    }

    public List<String> getSchemaPath() {
        if (this.tblName.isSimple()) {
            return ImmutableList.of();
        }
        return this.tblName.names.subList(0, this.tblName.names.size() - 1);
    }

    public String getName() {
        if (this.tblName.isSimple()) {
            return this.tblName.getSimple();
        }
        return (String)this.tblName.names.get(this.tblName.names.size() - 1);
    }

    public List<String> getFieldNames() {
        if (this.fieldList == null) {
            return ImmutableList.of();
        }
        ArrayList<String> columnNames = Lists.newArrayList();
        for (SqlNode node : this.fieldList.getList()) {
            columnNames.add(node.toString());
        }
        return columnNames;
    }

    public SqlNode getQuery() {
        return this.query;
    }
}

