/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.planner.sql.parser.DrillCompoundIdentifier;
import org.apache.drill.exec.planner.sql.parser.SqlCreateTable;
import org.apache.drill.exec.planner.sql.parser.SqlCreateView;
import org.apache.drill.exec.planner.sql.parser.SqlDescribeTable;
import org.apache.drill.exec.planner.sql.parser.SqlDropView;
import org.apache.drill.exec.planner.sql.parser.SqlShowFiles;
import org.apache.drill.exec.planner.sql.parser.SqlShowSchemas;
import org.apache.drill.exec.planner.sql.parser.SqlUseSchema;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.util.SqlShuttle;
import org.eigenbase.sql.util.SqlVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundIdentifierConverter
extends SqlShuttle {
    static final Logger logger = LoggerFactory.getLogger(CompoundIdentifierConverter.class);
    private boolean enableComplex = true;
    static final Map<Class<? extends SqlCall>, RewriteType[]> REWRITE_RULES;

    @Override
    public SqlNode visit(SqlIdentifier id) {
        if (id instanceof DrillCompoundIdentifier) {
            if (this.enableComplex) {
                return ((DrillCompoundIdentifier)id).getAsSqlNode();
            }
            return ((DrillCompoundIdentifier)id).getAsCompoundIdentifier();
        }
        return id;
    }

    @Override
    public SqlNode visit(SqlCall call) {
        ComplexExpressionAware argHandler = new ComplexExpressionAware(call);
        call.getOperator().acceptCall(this, call, false, argHandler);
        return (SqlNode)argHandler.result();
    }

    private static RewriteType[] R(RewriteType ... types) {
        return types;
    }

    static {
        RewriteType E = RewriteType.ENABLE;
        RewriteType D = RewriteType.DISABLE;
        RewriteType U = RewriteType.UNCHANGED;
        HashMap<Class<SqlJoin>, RewriteType[]> rules = Maps.newHashMap();
        rules.put(SqlSelect.class, CompoundIdentifierConverter.R(D, E, D, E, E, E, D, E, D, D));
        rules.put(SqlCreateTable.class, CompoundIdentifierConverter.R(D, D, E));
        rules.put(SqlCreateView.class, CompoundIdentifierConverter.R(D, E, E, D));
        rules.put(SqlDescribeTable.class, CompoundIdentifierConverter.R(D, D, E));
        rules.put(SqlDropView.class, CompoundIdentifierConverter.R(D));
        rules.put(SqlShowFiles.class, CompoundIdentifierConverter.R(D));
        rules.put(SqlShowSchemas.class, CompoundIdentifierConverter.R(D, D));
        rules.put(SqlUseSchema.class, CompoundIdentifierConverter.R(D));
        rules.put(SqlJoin.class, CompoundIdentifierConverter.R(D, D, D, D, D, E));
        REWRITE_RULES = ImmutableMap.copyOf(rules);
    }

    static enum RewriteType {
        UNCHANGED,
        DISABLE,
        ENABLE;

    }

    private class ComplexExpressionAware
    implements SqlBasicVisitor.ArgHandler<SqlNode> {
        boolean update;
        SqlNode[] clonedOperands;
        RewriteType[] rewriteTypes;
        private final SqlCall call;

        public ComplexExpressionAware(SqlCall call) {
            this.call = call;
            this.update = false;
            List<SqlNode> operands = call.getOperandList();
            this.clonedOperands = operands.toArray(new SqlNode[operands.size()]);
            this.rewriteTypes = REWRITE_RULES.get(call.getClass());
        }

        @Override
        public SqlNode result() {
            if (this.update) {
                return this.call.getOperator().createCall(this.call.getFunctionQuantifier(), this.call.getParserPosition(), this.clonedOperands);
            }
            return this.call;
        }

        @Override
        public SqlNode visitChild(SqlVisitor<SqlNode> visitor, SqlNode expr, int i, SqlNode operand) {
            if (operand == null) {
                return null;
            }
            boolean localEnableComplex = CompoundIdentifierConverter.this.enableComplex;
            if (this.rewriteTypes != null) {
                switch (this.rewriteTypes[i]) {
                    case DISABLE: {
                        CompoundIdentifierConverter.this.enableComplex = false;
                        break;
                    }
                    case ENABLE: {
                        CompoundIdentifierConverter.this.enableComplex = true;
                    }
                }
            }
            SqlNode newOperand = operand.accept(CompoundIdentifierConverter.this);
            CompoundIdentifierConverter.this.enableComplex = localEnableComplex;
            if (newOperand != operand) {
                this.update = true;
            }
            this.clonedOperands[i] = newOperand;
            return newOperand;
        }
    }
}

