/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.google.common.collect.ImmutableList;
import net.hydromatic.optiq.tools.RelConversionException;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.SqlShowSchemas;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;

public class ShowSchemasHandler
extends DefaultSqlHandler {
    public ShowSchemasHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws RelConversionException, ForemanSetupException {
        SqlShowSchemas node = ShowSchemasHandler.unwrap(sqlNode, SqlShowSchemas.class);
        ImmutableList<SqlIdentifier> selectList = ImmutableList.of(new SqlIdentifier("SCHEMA_NAME", SqlParserPos.ZERO));
        SqlIdentifier fromClause = new SqlIdentifier(ImmutableList.of("INFORMATION_SCHEMA", "SCHEMATA"), null, SqlParserPos.ZERO, null);
        SqlNode where = null;
        SqlNode likePattern = node.getLikePattern();
        if (likePattern != null) {
            where = DrillParserUtil.createCondition(new SqlIdentifier("SCHEMA_NAME", SqlParserPos.ZERO), SqlStdOperatorTable.LIKE, likePattern);
        } else if (node.getWhereClause() != null) {
            where = node.getWhereClause();
        }
        return new SqlSelect(SqlParserPos.ZERO, null, new SqlNodeList(selectList, SqlParserPos.ZERO), fromClause, where, null, null, null, null, null, null);
    }
}

