/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.ArrayList;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SetOptionHandler;
import org.apache.drill.exec.planner.sql.handlers.ShowFilesCommandResult;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlShowFiles;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFileHandler
extends DefaultSqlHandler {
    static final Logger logger = LoggerFactory.getLogger(SetOptionHandler.class);

    public ShowFileHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException {
        SqlIdentifier from = ((SqlShowFiles)sqlNode).getDb();
        DrillFileSystem fs = null;
        String defaultLocation = null;
        String fromDir = "./";
        try {
            SchemaPlus defaultSchema;
            SchemaPlus drillSchema = defaultSchema = this.context.getNewDefaultSchema();
            if (from != null) {
                try {
                    drillSchema = ShowFileHandler.findSchema(this.context.getRootSchema(), defaultSchema, from.names);
                }
                catch (Exception e) {
                    drillSchema = ShowFileHandler.findSchema(this.context.getRootSchema(), defaultSchema, from.names.subList(0, from.names.size() - 1));
                    fromDir = fromDir + (String)from.names.get(from.names.size() - 1);
                }
            }
            AbstractSchema tempSchema = ShowFileHandler.getDrillSchema(drillSchema);
            WorkspaceSchemaFactory.WorkspaceSchema schema = null;
            if (!(tempSchema instanceof WorkspaceSchemaFactory.WorkspaceSchema)) {
                throw new ValidationException("Unsupported schema");
            }
            schema = (WorkspaceSchemaFactory.WorkspaceSchema)tempSchema;
            fs = schema.getFS();
            defaultLocation = schema.getDefaultLocation();
        }
        catch (Exception e) {
            if (from == null) {
                return DirectPlan.createDirectPlan(this.context, false, "Show files without FROM / IN clause can be used only after specifying a default file system schema");
            }
            return DirectPlan.createDirectPlan(this.context, false, String.format("Current schema '%s' is not a file system schema. Can't execute show files on this schema.", from.toString()));
        }
        ArrayList<ShowFilesCommandResult> rows = new ArrayList<ShowFilesCommandResult>();
        for (FileStatus fileStatus : fs.list(false, new Path(defaultLocation, fromDir))) {
            ShowFilesCommandResult result = new ShowFilesCommandResult(fileStatus.getPath().getName(), fileStatus.isDir(), !fileStatus.isDir(), fileStatus.getLen(), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPermission().toString(), fileStatus.getAccessTime(), fileStatus.getModificationTime());
            rows.add(result);
        }
        return DirectPlan.createDirectPlan(this.context.getCurrentEndpoint(), rows.iterator(), ShowFilesCommandResult.class);
    }
}

