/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.sql.SqlExplain;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainHandler
extends DefaultSqlHandler {
    static final Logger logger = LoggerFactory.getLogger(ExplainHandler.class);
    private PlanProperties.Generator.ResultMode mode;
    private SqlExplainLevel level = SqlExplainLevel.ALL_ATTRIBUTES;

    public ExplainHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode node) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        SqlNode sqlNode = this.rewrite(node);
        SqlNode validated = this.validateNode(sqlNode);
        RelNode rel = this.convertToRel(validated);
        this.log("Optiq Logical", rel);
        DrillRel drel = this.convertToDrel(rel);
        this.log("Drill Logical", drel);
        if (this.mode == PlanProperties.Generator.ResultMode.LOGICAL) {
            LogicalExplain logicalResult = new LogicalExplain(drel, this.level, this.context);
            return DirectPlan.createDirectPlan(this.context, logicalResult);
        }
        Prel prel = this.convertToPrel(drel);
        this.log("Drill Physical", prel);
        PhysicalOperator pop = this.convertToPop(prel);
        PhysicalPlan plan = this.convertToPlan(pop);
        this.log("Drill Plan", plan);
        PhysicalExplain physicalResult = new PhysicalExplain(prel, plan, this.level, this.context);
        return DirectPlan.createDirectPlan(this.context, physicalResult);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws RelConversionException, ForemanSetupException {
        SqlExplain node = ExplainHandler.unwrap(sqlNode, SqlExplain.class);
        SqlLiteral op = (SqlLiteral)node.operand(2);
        SqlExplain.Depth depth = (SqlExplain.Depth)op.getValue();
        if (node.getDetailLevel() != null) {
            this.level = node.getDetailLevel();
        }
        switch (depth) {
            case LOGICAL: {
                this.mode = PlanProperties.Generator.ResultMode.LOGICAL;
                break;
            }
            case PHYSICAL: {
                this.mode = PlanProperties.Generator.ResultMode.PHYSICAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown depth " + depth);
            }
        }
        return node.operand(0);
    }

    public static class PhysicalExplain {
        public String text;
        public String json;

        public PhysicalExplain(RelNode node, PhysicalPlan plan, SqlExplainLevel level, QueryContext context) {
            this.text = PrelSequencer.printWithIds((Prel)node, level);
            this.json = plan.unparse(context.getConfig().getMapper().writer());
        }
    }

    public static class LogicalExplain {
        public String text;
        public String json;

        public LogicalExplain(RelNode node, SqlExplainLevel level, QueryContext context) {
            this.text = RelOptUtil.toString(node, level);
            DrillImplementor implementor = new DrillImplementor(new DrillParseContext(), PlanProperties.Generator.ResultMode.LOGICAL);
            implementor.go((DrillRel)node);
            LogicalPlan plan = implementor.getPlan();
            this.json = plan.unparse(context.getConfig());
        }
    }
}

