/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScreenRel;
import org.apache.drill.exec.planner.logical.DrillStoreRel;
import org.apache.drill.exec.planner.logical.RewriteProjectRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.apache.drill.exec.planner.physical.visitor.ComplexToJsonPrelVisitor;
import org.apache.drill.exec.planner.physical.visitor.ExcessiveExchangeIdentifier;
import org.apache.drill.exec.planner.physical.visitor.FinalColumnReorderer;
import org.apache.drill.exec.planner.physical.visitor.JoinPrelRenameVisitor;
import org.apache.drill.exec.planner.physical.visitor.MemoryEstimationVisitor;
import org.apache.drill.exec.planner.physical.visitor.RelUniqifier;
import org.apache.drill.exec.planner.physical.visitor.RewriteProjectToFlatten;
import org.apache.drill.exec.planner.physical.visitor.SelectionVectorPrelVisitor;
import org.apache.drill.exec.planner.physical.visitor.SplitUpComplexExpressions;
import org.apache.drill.exec.planner.physical.visitor.StarColumnConverter;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlHandler
extends AbstractSqlHandler {
    static final Logger logger = LoggerFactory.getLogger(DefaultSqlHandler.class);
    protected final SqlHandlerConfig config;
    protected final QueryContext context;
    protected final HepPlanner hepPlanner;
    protected final Planner planner;
    private Pointer<String> textPlan;
    private final long targetSliceSize;

    public DefaultSqlHandler(SqlHandlerConfig config) {
        this(config, null);
    }

    public DefaultSqlHandler(SqlHandlerConfig config, Pointer<String> textPlan) {
        this.planner = config.getPlanner();
        this.context = config.getContext();
        this.hepPlanner = config.getHepPlanner();
        this.config = config;
        this.textPlan = textPlan;
        this.targetSliceSize = this.context.getOptions().getOption((String)"planner.slice_target").num_val;
    }

    protected void log(String name, RelNode node) {
        if (logger.isDebugEnabled()) {
            logger.debug(name + " : \n" + RelOptUtil.toString(node, SqlExplainLevel.ALL_ATTRIBUTES));
        }
    }

    protected void log(String name, Prel node) {
        String plan = PrelSequencer.printWithIds(node, SqlExplainLevel.ALL_ATTRIBUTES);
        if (this.textPlan != null) {
            this.textPlan.value = plan;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(name + " : \n" + plan);
        }
    }

    protected void log(String name, PhysicalPlan plan) throws JsonProcessingException {
        if (logger.isDebugEnabled()) {
            String planText = plan.unparse(this.context.getConfig().getMapper().writer());
            logger.debug(name + " : \n" + planText);
        }
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        SqlNode rewrittenSqlNode = this.rewrite(sqlNode);
        SqlNode validated = this.validateNode(rewrittenSqlNode);
        RelNode rel = this.convertToRel(validated);
        rel = rel.accept(new RewriteProjectRel(this.planner.getTypeFactory(), this.context.getDrillOperatorTable()));
        this.log("Optiq Logical", rel);
        DrillRel drel = this.convertToDrel(rel);
        this.log("Drill Logical", drel);
        Prel prel = this.convertToPrel(drel);
        this.log("Drill Physical", prel);
        PhysicalOperator pop = this.convertToPop(prel);
        PhysicalPlan plan = this.convertToPlan(pop);
        this.log("Drill Plan", plan);
        return plan;
    }

    protected SqlNode validateNode(SqlNode sqlNode) throws ValidationException, RelConversionException, ForemanSetupException {
        return this.planner.validate(sqlNode);
    }

    protected RelNode convertToRel(SqlNode node) throws RelConversionException {
        RelNode convertedNode = this.planner.convert(node);
        this.hepPlanner.setRoot(convertedNode);
        return this.hepPlanner.findBestExp();
    }

    protected DrillRel convertToDrel(RelNode relNode) throws RelConversionException {
        RelNode convertedRelNode = this.planner.transform(0, relNode.getTraitSet().plus(DrillRel.DRILL_LOGICAL), relNode);
        if (convertedRelNode instanceof DrillStoreRel) {
            throw new UnsupportedOperationException();
        }
        return new DrillScreenRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode);
    }

    protected Prel convertToPrel(RelNode drel) throws RelConversionException {
        Preconditions.checkArgument(drel.getConvention() == DrillRel.DRILL_LOGICAL);
        RelTraitSet traits = drel.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(DrillDistributionTrait.SINGLETON);
        Prel phyRelNode = (Prel)this.planner.transform(1, traits, drel);
        OptionManager queryOptions = this.context.getOptions();
        if (this.context.getPlannerSettings().isMemoryEstimationEnabled() && !MemoryEstimationVisitor.enoughMemory(phyRelNode, queryOptions, this.context.getActiveEndpoints().size())) {
            this.log("Not enough memory for this plan", phyRelNode);
            logger.debug("Re-planning without hash operations.");
            queryOptions.setOption(OptionValue.createBoolean(OptionValue.OptionType.QUERY, PlannerSettings.HASHJOIN.getOptionName(), false));
            queryOptions.setOption(OptionValue.createBoolean(OptionValue.OptionType.QUERY, PlannerSettings.HASHAGG.getOptionName(), false));
            phyRelNode = (Prel)this.planner.transform(1, traits, drel);
        }
        phyRelNode = StarColumnConverter.insertRenameProject(phyRelNode, phyRelNode.getRowType());
        phyRelNode = JoinPrelRenameVisitor.insertRenameProject(phyRelNode);
        phyRelNode = phyRelNode.accept(new SplitUpComplexExpressions(this.planner.getTypeFactory(), this.context.getDrillOperatorTable(), this.context.getPlannerSettings().functionImplementationRegistry), null);
        phyRelNode = phyRelNode.accept(new RewriteProjectToFlatten(this.planner.getTypeFactory(), this.context.getDrillOperatorTable()), null);
        phyRelNode = FinalColumnReorderer.addFinalColumnOrdering(phyRelNode);
        phyRelNode = ExcessiveExchangeIdentifier.removeExcessiveEchanges(phyRelNode, this.targetSliceSize);
        phyRelNode = SelectionVectorPrelVisitor.addSelectionRemoversWhereNecessary(phyRelNode);
        if (!this.context.getSession().isSupportComplexTypes()) {
            logger.debug("Client does not support complex types, add ComplexToJson operator.");
            phyRelNode = ComplexToJsonPrelVisitor.addComplexToJsonPrel(phyRelNode);
        }
        phyRelNode = RelUniqifier.uniqifyGraph(phyRelNode);
        return phyRelNode;
    }

    protected PhysicalOperator convertToPop(Prel prel) throws IOException {
        PhysicalPlanCreator creator = new PhysicalPlanCreator(this.context, PrelSequencer.getIdMap(prel));
        PhysicalOperator op = prel.getPhysicalOperator(creator);
        return op;
    }

    protected PhysicalPlan convertToPlan(PhysicalOperator op) {
        PlanProperties.PlanPropertiesBuilder propsBuilder = PlanProperties.builder();
        propsBuilder.type(PlanProperties.PlanType.APACHE_DRILL_PHYSICAL);
        propsBuilder.version(1);
        propsBuilder.options(new JSONOptions(this.context.getOptions().getOptionList()));
        propsBuilder.resultMode(PlanProperties.Generator.ResultMode.EXEC);
        propsBuilder.generator(this.getClass().getSimpleName(), "");
        return new PhysicalPlan(propsBuilder.build(), DefaultSqlHandler.getPops(op));
    }

    public static List<PhysicalOperator> getPops(PhysicalOperator root) {
        ArrayList<PhysicalOperator> ops = Lists.newArrayList();
        PopCollector c = new PopCollector();
        root.accept(c, ops);
        return ops;
    }

    public SqlNode rewrite(SqlNode node) throws RelConversionException, ForemanSetupException {
        return node;
    }

    private static class PopCollector
    extends AbstractPhysicalVisitor<Void, Collection<PhysicalOperator>, RuntimeException> {
        private PopCollector() {
        }

        @Override
        public Void visitOp(PhysicalOperator op, Collection<PhysicalOperator> collection) throws RuntimeException {
            collection.add(op);
            for (PhysicalOperator o : op) {
                o.accept(this, collection);
            }
            return null;
        }
    }
}

