/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScreenRel;
import org.apache.drill.exec.planner.logical.DrillStoreRel;
import org.apache.drill.exec.planner.logical.DrillWriterRel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.SqlCreateTable;
import org.apache.drill.exec.planner.types.DrillFixedRelDataTypeImpl;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlNode;

public class CreateTableHandler
extends DefaultSqlHandler {
    public CreateTableHandler(SqlHandlerConfig config) {
        super(config);
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException, ForemanSetupException {
        SqlCreateTable sqlCreateTable = CreateTableHandler.unwrap(sqlNode, SqlCreateTable.class);
        try {
            SchemaPlus schema;
            AbstractSchema drillSchema;
            SqlNode validatedQuery = this.validateNode(sqlCreateTable.getQuery());
            RelNode relQuery = this.convertToRel(validatedQuery);
            List<String> tblFiledNames = sqlCreateTable.getFieldNames();
            RelDataType queryRowType = relQuery.getRowType();
            if (tblFiledNames.size() > 0) {
                if (tblFiledNames.size() != queryRowType.getFieldCount()) {
                    return DirectPlan.createDirectPlan(this.context, false, "Table's field list and the table's query field list have different counts.");
                }
                for (String field : queryRowType.getFieldNames()) {
                    if (!field.equals("*")) continue;
                    return DirectPlan.createDirectPlan(this.context, false, "Table's query field list has a '*', which is invalid when table's field list is specified.");
                }
            }
            if (tblFiledNames.size() > 0) {
                DrillFixedRelDataTypeImpl rowType = new DrillFixedRelDataTypeImpl(this.planner.getTypeFactory(), tblFiledNames);
                relQuery = RelOptUtil.createCastRel(relQuery, rowType, true);
            }
            if (!(drillSchema = CreateTableHandler.getDrillSchema(schema = CreateTableHandler.findSchema(this.context.getRootSchema(), this.context.getNewDefaultSchema(), sqlCreateTable.getSchemaPath()))).isMutable()) {
                return DirectPlan.createDirectPlan(this.context, false, String.format("Current schema '%s' is not a mutable schema. Can't create tables in this schema.", drillSchema.getFullSchemaName()));
            }
            String newTblName = sqlCreateTable.getName();
            if (schema.getTable(newTblName) != null) {
                return DirectPlan.createDirectPlan(this.context, false, String.format("Table '%s' already exists.", newTblName));
            }
            this.log("Optiq Logical", relQuery);
            DrillRel drel = this.convertToDrel(relQuery, drillSchema, newTblName);
            this.log("Drill Logical", drel);
            Prel prel = this.convertToPrel(drel);
            this.log("Drill Physical", prel);
            PhysicalOperator pop = this.convertToPop(prel);
            PhysicalPlan plan = this.convertToPlan(pop);
            this.log("Drill Plan", plan);
            return plan;
        }
        catch (Exception e) {
            logger.error("Failed to create table '{}'", (Object)sqlCreateTable.getName(), (Object)e);
            return DirectPlan.createDirectPlan(this.context, false, String.format("Error: %s", e.getMessage()));
        }
    }

    private DrillRel convertToDrel(RelNode relNode, AbstractSchema schema, String tableName) throws RelConversionException {
        RelNode convertedRelNode = this.planner.transform(0, relNode.getTraitSet().plus(DrillRel.DRILL_LOGICAL), relNode);
        if (convertedRelNode instanceof DrillStoreRel) {
            throw new UnsupportedOperationException();
        }
        DrillWriterRel writerRel = new DrillWriterRel(convertedRelNode.getCluster(), convertedRelNode.getTraitSet(), convertedRelNode, schema.createNewTable(tableName));
        return new DrillScreenRel(writerRel.getCluster(), writerRel.getTraitSet(), writerRel);
    }
}

