/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.io.IOException;
import java.util.ArrayList;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillRuleSets;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.sql.DrillConvertletTable;
import org.apache.drill.exec.planner.sql.QueryInputException;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ExplainHandler;
import org.apache.drill.exec.planner.sql.handlers.SetOptionHandler;
import org.apache.drill.exec.planner.sql.handlers.SqlHandlerConfig;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.planner.sql.parser.impl.DrillParserWithCompoundIdConverter;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.rules.ReduceExpressionsRule;
import org.eigenbase.rel.rules.WindowedAggSplitterRule;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgramBuilder;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSqlWorker {
    static final Logger logger = LoggerFactory.getLogger(DrillSqlWorker.class);
    private final Planner planner;
    private final HepPlanner hepPlanner;
    private final QueryContext context;

    public DrillSqlWorker(QueryContext context) {
        ArrayList<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(DrillDistributionTraitDef.INSTANCE);
        traitDefs.add(RelCollationTraitDef.INSTANCE);
        this.context = context;
        DrillCostBase.DrillCostFactory costFactory = context.getPlannerSettings().useDefaultCosting() ? null : new DrillCostBase.DrillCostFactory();
        int idMaxLength = (int)context.getPlannerSettings().getIdentifierMaxLength();
        FrameworkConfig config = Frameworks.newConfigBuilder().parserConfig(new SqlParser.ParserConfigImpl(Lex.MYSQL, idMaxLength)).parserFactory(DrillParserWithCompoundIdConverter.FACTORY).defaultSchema(context.getNewDefaultSchema()).operatorTable(context.getDrillOperatorTable()).traitDefs(traitDefs).convertletTable(new DrillConvertletTable()).context(context.getPlannerSettings()).ruleSets(this.getRules(context)).costFactory(costFactory).build();
        this.planner = Frameworks.getPlanner(config);
        HepProgramBuilder builder = new HepProgramBuilder();
        builder.addRuleClass(ReduceExpressionsRule.class);
        builder.addRuleClass(WindowedAggSplitterRule.class);
        this.hepPlanner = new HepPlanner(builder.build());
        this.hepPlanner.addRule(ReduceExpressionsRule.CALC_INSTANCE);
        this.hepPlanner.addRule(WindowedAggSplitterRule.PROJECT);
    }

    private RuleSet[] getRules(QueryContext context) {
        StoragePluginRegistry storagePluginRegistry = context.getStorage();
        RuleSet drillPhysicalMem = DrillRuleSets.mergedRuleSets(DrillRuleSets.getPhysicalRules(context), storagePluginRegistry.getStoragePluginRuleSet());
        RuleSet[] allRules = new RuleSet[]{DrillRuleSets.getDrillBasicRules(context), drillPhysicalMem};
        return allRules;
    }

    public PhysicalPlan getPlan(String sql, Pointer<String> textPlan) throws ForemanSetupException {
        AbstractSqlHandler handler;
        SqlNode sqlNode;
        try {
            sqlNode = this.planner.parse(sql);
        }
        catch (SqlParseException e) {
            throw new QueryInputException("Failure parsing SQL. " + e.getMessage(), e);
        }
        SqlHandlerConfig config = new SqlHandlerConfig(this.hepPlanner, this.planner, this.context);
        switch (sqlNode.getKind()) {
            case EXPLAIN: {
                handler = new ExplainHandler(config);
                break;
            }
            case SET_OPTION: {
                handler = new SetOptionHandler(this.context);
                break;
            }
            case OTHER: {
                if (sqlNode instanceof DrillSqlCall) {
                    handler = ((DrillSqlCall)sqlNode).getSqlHandler(config);
                    break;
                }
            }
            default: {
                handler = new DefaultSqlHandler(config, textPlan);
            }
        }
        try {
            return ((AbstractSqlHandler)handler).getPlan(sqlNode);
        }
        catch (ValidationException e) {
            throw new QueryInputException("Failure validating SQL. " + e.getMessage(), e);
        }
        catch (IOException | RelConversionException e) {
            throw new QueryInputException("Failure handling SQL.", e);
        }
    }
}

