/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import com.google.common.base.Preconditions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.sql.Checker;
import org.apache.drill.exec.planner.sql.DynamicReturnType;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSqlOperator
extends SqlFunction {
    static final Logger logger = LoggerFactory.getLogger(DrillSqlOperator.class);
    private static final TypeProtos.MajorType NONE = TypeProtos.MajorType.getDefaultInstance();
    private final TypeProtos.MajorType returnType;

    public DrillSqlOperator(String name, int argCount) {
        this(name, argCount, TypeProtos.MajorType.getDefaultInstance());
    }

    public DrillSqlOperator(String name, int argCount, TypeProtos.MajorType returnType) {
        super(new SqlIdentifier(name, SqlParserPos.ZERO), DynamicReturnType.INSTANCE, null, new Checker(argCount), null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        this.returnType = Preconditions.checkNotNull(returnType);
    }

    protected RelDataType getReturnDataType(RelDataTypeFactory factory) {
        if (TypeProtos.MinorType.BIT.equals(this.returnType.getMinorType())) {
            return factory.createSqlType(SqlTypeName.BOOLEAN);
        }
        return factory.createSqlType(SqlTypeName.ANY);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        if (NONE.equals(this.returnType)) {
            return validator.getTypeFactory().createSqlType(SqlTypeName.ANY);
        }
        return this.getReturnDataType(validator.getTypeFactory());
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        if (NONE.equals(this.returnType)) {
            return super.inferReturnType(opBinding);
        }
        return this.getReturnDataType(opBinding.getTypeFactory());
    }
}

