/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillOperatorTable
extends SqlStdOperatorTable {
    static final Logger logger = LoggerFactory.getLogger(DrillOperatorTable.class);
    private static final SqlOperatorTable inner = SqlStdOperatorTable.instance();
    private List<SqlOperator> operators;
    private ArrayListMultimap<String, SqlOperator> opMap = ArrayListMultimap.create();

    public DrillOperatorTable(FunctionImplementationRegistry registry) {
        this.operators = Lists.newArrayList();
        this.operators.addAll(inner.getOperatorList());
        registry.register(this);
    }

    public void add(String name, SqlOperator op) {
        this.operators.add(op);
        this.opMap.put(name, op);
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax == SqlSyntax.FUNCTION) {
            inner.lookupOperatorOverloads(opName, category, syntax, operatorList);
            if (!operatorList.isEmpty()) {
                return;
            }
            List drillOps = this.opMap.get((Object)opName.getSimple().toLowerCase());
            if (drillOps != null) {
                operatorList.addAll(drillOps);
            }
        } else {
            inner.lookupOperatorOverloads(opName, category, syntax, operatorList);
        }
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return this.operators;
    }

    public List<SqlOperator> getSqlOperator(String name) {
        return this.opMap.get((Object)name.toLowerCase());
    }
}

