/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.tools.RelConversionException;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.planner.physical.visitor.RexVisitorComplexExprSplitter;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.type.SqlTypeName;

public class SplitUpComplexExpressions
extends BasePrelVisitor<Prel, Object, RelConversionException> {
    RelDataTypeFactory factory;
    DrillOperatorTable table;
    FunctionImplementationRegistry funcReg;

    public SplitUpComplexExpressions(RelDataTypeFactory factory, DrillOperatorTable table, FunctionImplementationRegistry funcReg) {
        this.factory = factory;
        this.table = table;
        this.funcReg = funcReg;
    }

    @Override
    public Prel visitPrel(Prel prel, Object value) throws RelConversionException {
        ArrayList<RelNode> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, null);
            children.add(child);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitProject(ProjectPrel project, Object unused) throws RelConversionException {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        ArrayList<RelDataTypeField> relDataTypes = new ArrayList<RelDataTypeField>();
        ArrayList<RelDataTypeField> origRelDataTypes = new ArrayList<RelDataTypeField>();
        int i = 0;
        PrelUtil.ProjectPushInfo columnInfo = PrelUtil.getColumns(project.getInput(0).getRowType(), project.getProjects());
        if (columnInfo == null) {
            return project;
        }
        int lastRexInput = columnInfo.desiredFields.size();
        RexVisitorComplexExprSplitter exprSplitter = new RexVisitorComplexExprSplitter(this.factory, this.funcReg, lastRexInput);
        for (RexNode rex : project.getChildExps()) {
            origRelDataTypes.add(project.getRowType().getFieldList().get(i));
            ++i;
            exprList.add(rex.accept(exprSplitter));
        }
        List<RexNode> complexExprs = exprSplitter.getComplexExprs();
        RelNode originalInput = ((Prel)project.getInput(0)).accept(this, null);
        ArrayList<RexNode> allExprs = new ArrayList<RexNode>();
        for (int index = 0; index < lastRexInput; ++index) {
            RexBuilder builder = new RexBuilder(this.factory);
            allExprs.add(builder.makeInputRef(new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), index));
            relDataTypes.add(new RelDataTypeFieldImpl("EXPR$" + index, allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
        }
        int index = lastRexInput - 1;
        if (complexExprs.size() > 0) {
            RexBuilder builder;
            while (complexExprs.size() > 0) {
                if (index >= lastRexInput) {
                    allExprs.remove(allExprs.size() - 1);
                    builder = new RexBuilder(this.factory);
                    allExprs.add(builder.makeInputRef(new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), index));
                }
                RexNode currRexNode = complexExprs.remove(0);
                allExprs.add(currRexNode);
                relDataTypes.add(new RelDataTypeFieldImpl("EXPR$" + ++index, allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
                ProjectPrel childProject = new ProjectPrel(project.getCluster(), project.getTraitSet(), originalInput, ImmutableList.copyOf(allExprs), new RelRecordType((List<RelDataTypeField>)relDataTypes));
                originalInput = childProject;
            }
            allExprs.remove(allExprs.size() - 1);
            builder = new RexBuilder(this.factory);
            allExprs.add(builder.makeInputRef(new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), index));
            relDataTypes.add(new RelDataTypeFieldImpl("EXPR$" + index, allExprs.size(), this.factory.createSqlType(SqlTypeName.ANY)));
        }
        return new ProjectPrel(project.getCluster(), project.getTraitSet(), originalInput, exprList, new RelRecordType((List<RelDataTypeField>)origRelDataTypes));
    }
}

