/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexVisitorImpl;

public class RexVisitorComplexExprSplitter
extends RexVisitorImpl<RexNode> {
    RelDataTypeFactory factory;
    FunctionImplementationRegistry funcReg;
    List<RexNode> complexExprs;
    int lastUsedIndex;

    public RexVisitorComplexExprSplitter(RelDataTypeFactory factory, FunctionImplementationRegistry funcReg, int firstUnused) {
        super(true);
        this.factory = factory;
        this.funcReg = funcReg;
        this.complexExprs = new ArrayList<RexNode>();
        this.lastUsedIndex = firstUnused;
    }

    public List<RexNode> getComplexExprs() {
        return this.complexExprs;
    }

    @Override
    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    @Override
    public RexNode visitLocalRef(RexLocalRef localRef) {
        return localRef;
    }

    @Override
    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    @Override
    public RexNode visitOver(RexOver over) {
        return over;
    }

    @Override
    public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
        return correlVariable;
    }

    @Override
    public RexNode visitCall(RexCall call) {
        String functionName = call.getOperator().getName();
        ArrayList<RexNode> newOps = new ArrayList<RexNode>();
        for (RexNode operand : call.operands) {
            newOps.add(operand.accept(this));
        }
        if (this.funcReg.isFunctionComplexOutput(functionName)) {
            RexBuilder builder = new RexBuilder(this.factory);
            RexInputRef ret = builder.makeInputRef(new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), this.lastUsedIndex);
            ++this.lastUsedIndex;
            this.complexExprs.add(call.clone(new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), newOps));
            return ret;
        }
        return call.clone(call.getType(), newOps);
    }

    @Override
    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    @Override
    public RexNode visitRangeRef(RexRangeRef rangeRef) {
        return rangeRef;
    }

    @Override
    public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
        return fieldAccess;
    }
}

