/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.optiq.tools.RelConversionException;
import org.apache.drill.exec.planner.physical.FlattenPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;

public class RewriteProjectToFlatten
extends BasePrelVisitor<Prel, Object, RelConversionException> {
    RelDataTypeFactory factory;
    DrillOperatorTable table;

    public RewriteProjectToFlatten(RelDataTypeFactory factory, DrillOperatorTable table) {
        this.factory = factory;
        this.table = table;
    }

    @Override
    public Prel visitPrel(Prel prel, Object value) throws RelConversionException {
        ArrayList<RelNode> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, null);
            children.add(child);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitProject(ProjectPrel node, Object unused) throws RelConversionException {
        ProjectPrel project = node;
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        boolean rewrite = false;
        ArrayList<RelDataTypeField> relDataTypes = new ArrayList<RelDataTypeField>();
        int i = 0;
        RexInputRef flatttenExpr = null;
        Iterator<RexNode> i$ = project.getChildExps().iterator();
        while (i$.hasNext()) {
            RexNode rex;
            RexNode newExpr = rex = i$.next();
            if (rex instanceof RexCall) {
                RexCall function = (RexCall)rex;
                String functionName = function.getOperator().getName();
                int nArgs = function.getOperands().size();
                if (functionName.equalsIgnoreCase("flatten")) {
                    rewrite = true;
                    if (function.getOperands().size() != 1) {
                        throw new RelConversionException("Flatten expression expects a single input.");
                    }
                    newExpr = function.getOperands().get(0);
                    RexBuilder builder = new RexBuilder(this.factory);
                    flatttenExpr = builder.makeInputRef(new RelDataTypeDrillImpl(new RelDataTypeHolder(), this.factory), i);
                }
            }
            relDataTypes.add(project.getRowType().getFieldList().get(i));
            ++i;
            exprList.add(newExpr);
        }
        if (rewrite) {
            Prel newChild = ((Prel)project.getInput(0)).accept(this, null);
            ProjectPrel newProject = new ProjectPrel(node.getCluster(), project.getTraitSet(), newChild, exprList, new RelRecordType((List<RelDataTypeField>)relDataTypes));
            FlattenPrel flatten = new FlattenPrel(project.getCluster(), project.getTraitSet(), newProject, flatttenExpr);
            return flatten;
        }
        Prel child = ((Prel)project.getChild()).accept(this, null);
        return new ProjectPrel(node.getCluster(), project.getTraitSet(), child, exprList, new RelRecordType((List<RelDataTypeField>)relDataTypes));
    }
}

