/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.apache.drill.exec.server.options.OptionManager;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryEstimationVisitor
extends BasePrelVisitor<Double, Void, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(MemoryEstimationVisitor.class);

    public static boolean enoughMemory(Prel prel, OptionManager options, int numDrillbits) {
        long allottedMemory = options.getOption((String)"planner.memory.max_query_memory_per_node").num_val * (long)numDrillbits;
        long estimatedMemory = (long)Math.ceil(prel.accept(new MemoryEstimationVisitor(), null) / 1048576.0);
        if ((estimatedMemory += options.getOption((String)"planner.memory.non_blocking_operators_memory").num_val * (long)numDrillbits) > allottedMemory) {
            logger.debug("Estimated memory (" + estimatedMemory + ") exceeds maximum allowed (" + allottedMemory + ")");
        } else {
            logger.debug("Estimated memory (" + estimatedMemory + ") within maximum allowed (" + allottedMemory + ")");
        }
        return estimatedMemory <= allottedMemory;
    }

    @Override
    public Double visitPrel(Prel prel, Void value) throws RuntimeException {
        return ((DrillCostBase)RelMetadataQuery.getCumulativeCost(prel)).getMemory();
    }
}

