/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillWindowRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.StreamingWindowPrel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.WindowRelBase;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.sql.SqlAggFunction;

public class StreamingWindowPrule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new StreamingWindowPrule();

    private StreamingWindowPrule() {
        super(RelOptHelper.some(DrillWindowRel.class, DrillRel.DRILL_LOGICAL, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "Prel.WindowPrule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DrillWindowRel window = (DrillWindowRel)call.rel(0);
        Object input = call.rel(1);
        for (final Ord w : Ord.zip(window.windows)) {
            WindowRelBase.Window windowBase = (WindowRelBase.Window)w.getValue();
            DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionFields(windowBase)));
            RelCollation collation = this.getCollation(windowBase);
            RelTraitSet traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(collation).plus(distOnAllKeys);
            RelNode convertedInput = StreamingWindowPrule.convert(input, traits);
            ArrayList<RelDataTypeField> newRowFields = Lists.newArrayList();
            for (RelDataTypeField field : convertedInput.getRowType().getFieldList()) {
                newRowFields.add(field);
            }
            Iterable<RelDataTypeField> newWindowFields = Iterables.filter(window.getRowType().getFieldList(), new Predicate<RelDataTypeField>(){

                public boolean apply(RelDataTypeField relDataTypeField) {
                    return relDataTypeField.getName().startsWith("w" + w.i + "$");
                }
            });
            for (RelDataTypeField newField : newWindowFields) {
                newRowFields.add(newField);
            }
            RelRecordType rowType = new RelRecordType((List<RelDataTypeField>)newRowFields);
            ArrayList<WindowRelBase.RexWinAggCall> newWinAggCalls = Lists.newArrayList();
            for (Ord<WindowRelBase.RexWinAggCall> aggOrd : Ord.zip(windowBase.aggCalls)) {
                WindowRelBase.RexWinAggCall aggCall = (WindowRelBase.RexWinAggCall)aggOrd.getValue();
                newWinAggCalls.add(new WindowRelBase.RexWinAggCall((SqlAggFunction)aggCall.getOperator(), aggCall.getType(), aggCall.getOperands(), aggOrd.i));
            }
            windowBase = new WindowRelBase.Window(windowBase.groupSet, windowBase.isRows, windowBase.lowerBound, windowBase.upperBound, windowBase.orderKeys, newWinAggCalls);
            input = new StreamingWindowPrel(window.getCluster(), window.getTraitSet().merge(traits), convertedInput, window.getConstants(), (RelDataType)rowType, windowBase);
        }
        call.transformTo((RelNode)input);
    }

    private RelCollation getCollation(WindowRelBase.Window window) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        for (int group : BitSets.toIter(window.groupSet)) {
            fields.add(new RelFieldCollation(group));
        }
        return RelCollationImpl.of(fields);
    }

    private List<DrillDistributionTrait.DistributionField> getDistributionFields(WindowRelBase.Window window) {
        ArrayList<DrillDistributionTrait.DistributionField> groupByFields = Lists.newArrayList();
        for (int group : BitSets.toIter(window.groupSet)) {
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(group);
            groupByFields.add(field);
        }
        return groupByFields;
    }
}

