/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.planner.common.DrillWindowRelBase;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.WindowRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexLiteral;

public class StreamingWindowPrel
extends DrillWindowRelBase
implements Prel {
    public StreamingWindowPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, WindowRelBase.Window window) {
        super(cluster, traits, child, constants, rowType, Collections.singletonList(window));
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new StreamingWindowPrel(this.getCluster(), traitSet, StreamingWindowPrel.sole(inputs), (List<RexLiteral>)this.constants, this.getRowType(), (WindowRelBase.Window)this.windows.get(0));
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getChild();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        List<String> childFields = this.getChild().getRowType().getFieldNames();
        Preconditions.checkState(this.windows.size() == 1, "Only one window is expected in WindowPrel");
        WindowRelBase.Window window = (WindowRelBase.Window)this.windows.get(0);
        ArrayList<NamedExpression> withins = Lists.newArrayList();
        ArrayList<NamedExpression> aggs = Lists.newArrayList();
        Iterator<Object> i$ = BitSets.toIter(window.groupSet).iterator();
        while (i$.hasNext()) {
            int group = i$.next();
            FieldReference fr = new FieldReference((CharSequence)childFields.get(group), ExpressionPosition.UNKNOWN);
            withins.add(new NamedExpression(fr, fr));
        }
        for (AggregateCall aggCall : window.getAggregateCalls(this)) {
            FieldReference ref = new FieldReference(aggCall.getName());
            LogicalExpression expr = this.toDrill(aggCall, childFields);
            aggs.add(new NamedExpression(expr, ref));
        }
        WindowPOP windowPOP = new WindowPOP(childPOP, withins.toArray(new NamedExpression[withins.size()]), aggs.toArray(new NamedExpression[aggs.size()]), Long.MIN_VALUE, Long.MIN_VALUE);
        creator.addMetadata(this, windowPOP);
        return windowPOP;
    }

    protected LogicalExpression toDrill(AggregateCall call, List<String> fn) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            args.add(new FieldReference(fn.get(i)));
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        FunctionCall expr = new FunctionCall(call.getAggregation().getName().toLowerCase(), args, ExpressionPosition.UNKNOWN);
        return expr;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.ALL;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getChild());
    }
}

