/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.AggPruleBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashToMergeExchangePrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.StreamAggPrel;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.apache.drill.exec.planner.physical.UnionExchangePrel;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.trace.EigenbaseTrace;

public class StreamAggPrule
extends AggPruleBase {
    public static final RelOptRule INSTANCE = new StreamAggPrule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private StreamAggPrule() {
        super(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "StreamAggPrule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        return PrelUtil.getPlannerSettings(call.getPlanner()).isStreamAggEnabled();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        final DrillAggregateRel aggregate = (DrillAggregateRel)call.rel(0);
        final RelNode input = aggregate.getChild();
        final RelCollation collation = this.getCollation(aggregate);
        RelTraitSet traits = null;
        if (aggregate.containsDistinctCall()) {
            return;
        }
        try {
            if (aggregate.getGroupSet().isEmpty()) {
                DrillDistributionTrait singleDist = DrillDistributionTrait.SINGLETON;
                final RelTraitSet singleDistTrait = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(singleDist);
                if (this.create2PhasePlan(call, aggregate)) {
                    traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL);
                    RelNode convertedInput = StreamAggPrule.convert(input, traits);
                    new SubsetTransformer<DrillAggregateRel, InvalidRelException>(call){

                        @Override
                        public RelNode convertChild(DrillAggregateRel join, RelNode rel) throws InvalidRelException {
                            DrillDistributionTrait toDist = rel.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE);
                            RelTraitSet traits = this.newTraitSet(Prel.DRILL_PHYSICAL, toDist);
                            RelNode newInput = Prule.convert(input, traits);
                            StreamAggPrel phase1Agg = new StreamAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getGroupSet(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of2);
                            UnionExchangePrel exch = new UnionExchangePrel(phase1Agg.getCluster(), singleDistTrait, phase1Agg);
                            return new StreamAggPrel(aggregate.getCluster(), singleDistTrait, exch, aggregate.getGroupSet(), phase1Agg.getPhase2AggCalls(), AggPrelBase.OperatorPhase.PHASE_2of2);
                        }
                    }.go(aggregate, convertedInput);
                } else {
                    this.createTransformRequest(call, aggregate, input, singleDistTrait);
                }
            } else {
                final DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, true)));
                traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(collation).plus(distOnAllKeys);
                this.createTransformRequest(call, aggregate, input, traits);
                DrillDistributionTrait distOnOneKey = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, false)));
                traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(collation).plus(distOnOneKey);
                if (this.create2PhasePlan(call, aggregate)) {
                    traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL);
                    RelNode convertedInput = StreamAggPrule.convert(input, traits);
                    new SubsetTransformer<DrillAggregateRel, InvalidRelException>(call){

                        @Override
                        public RelNode convertChild(DrillAggregateRel aggregate, RelNode rel) throws InvalidRelException {
                            DrillDistributionTrait toDist = rel.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE);
                            RelTraitSet traits = this.newTraitSet(Prel.DRILL_PHYSICAL, collation, toDist);
                            RelNode newInput = Prule.convert(input, traits);
                            StreamAggPrel phase1Agg = new StreamAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getGroupSet(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of2);
                            int numEndPoints = PrelUtil.getSettings(phase1Agg.getCluster()).numEndPoints();
                            HashToMergeExchangePrel exch = new HashToMergeExchangePrel(phase1Agg.getCluster(), phase1Agg.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(distOnAllKeys), phase1Agg, ImmutableList.copyOf(StreamAggPrule.this.getDistributionField(aggregate, true)), collation, numEndPoints);
                            return new StreamAggPrel(aggregate.getCluster(), exch.getTraitSet(), exch, aggregate.getGroupSet(), phase1Agg.getPhase2AggCalls(), AggPrelBase.OperatorPhase.PHASE_2of2);
                        }
                    }.go(aggregate, convertedInput);
                }
            }
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }

    private void createTransformRequest(RelOptRuleCall call, DrillAggregateRel aggregate, RelNode input, RelTraitSet traits) throws InvalidRelException {
        RelNode convertedInput = StreamAggPrule.convert(input, traits);
        StreamAggPrel newAgg = new StreamAggPrel(aggregate.getCluster(), traits, convertedInput, aggregate.getGroupSet(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of1);
        call.transformTo(newAgg);
    }

    private RelCollation getCollation(DrillAggregateRel rel) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        for (int group : BitSets.toIter(rel.getGroupSet())) {
            fields.add(new RelFieldCollation(group));
        }
        return RelCollationImpl.of(fields);
    }
}

