/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.physical.DrillScanPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanPrel
extends AbstractRelNode
implements DrillScanPrel {
    static final Logger logger = LoggerFactory.getLogger(ScanPrel.class);
    protected final GroupScan groupScan;
    private final RelDataType rowType;

    public ScanPrel(RelOptCluster cluster, RelTraitSet traits, GroupScan groupScan, RelDataType rowType) {
        super(cluster, traits);
        this.groupScan = ScanPrel.getCopy(groupScan);
        this.rowType = rowType;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new ScanPrel(this.getCluster(), traitSet, this.groupScan, this.rowType);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ScanPrel(this.getCluster(), this.getTraitSet(), ScanPrel.getCopy(this.groupScan), this.rowType);
    }

    private static GroupScan getCopy(GroupScan scan) {
        try {
            return (GroupScan)scan.getNewWithChildren(Collections.emptyList());
        }
        catch (ExecutionSetupException e) {
            throw new DrillRuntimeException("Unexpected failure while coping node.", e);
        }
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        return creator.addMetadata(this, this.groupScan);
    }

    public GroupScan getGroupScan() {
        return this.groupScan;
    }

    public static ScanPrel create(RelNode old, RelTraitSet traitSets, GroupScan scan, RelDataType rowType) {
        return new ScanPrel(old.getCluster(), traitSets, ScanPrel.getCopy(scan), rowType);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupscan", this.groupScan.getDigest());
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public double getRows() {
        return this.groupScan.getScanStats().getRecordCount();
    }

    @Override
    public Iterator<Prel> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitScan(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }
}

