/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.LimitPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.apache.drill.exec.planner.physical.SortPrel;
import org.apache.drill.exec.planner.physical.TopNPrel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexLiteral;

public class PushLimitToTopN
extends Prule {
    public static final RelOptRule INSTANCE = new PushLimitToTopN();

    private PushLimitToTopN() {
        super(RelOptHelper.some(LimitPrel.class, RelOptHelper.some(SingleMergeExchangePrel.class, RelOptHelper.any(SortPrel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "PushLimitToTopN");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LimitPrel limit = (LimitPrel)call.rel(0);
        SingleMergeExchangePrel smex = (SingleMergeExchangePrel)call.rel(1);
        SortPrel sort = (SortPrel)call.rel(2);
        int offset = limit.getOffset() != null ? Math.max(0, RexLiteral.intValue(limit.getOffset())) : 0;
        int fetch = limit.getFetch() != null ? Math.max(0, RexLiteral.intValue(limit.getFetch())) : 0;
        TopNPrel topN = new TopNPrel(limit.getCluster(), sort.getTraitSet(), sort.getChild(), offset + fetch, sort.getCollation());
        LimitPrel newLimit = new LimitPrel(limit.getCluster(), limit.getTraitSet(), new SingleMergeExchangePrel(smex.getCluster(), smex.getTraitSet(), topN, sort.getCollation()), limit.getOffset(), limit.getFetch());
        call.transformTo(newLimit);
    }
}

