/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalPlanCreator {
    static final Logger logger = LoggerFactory.getLogger(PhysicalPlanCreator.class);
    private final Map<Prel, PrelSequencer.OpId> opIdMap;
    private List<PhysicalOperator> popList;
    private final QueryContext context;
    PhysicalPlan plan = null;

    public PhysicalPlanCreator(QueryContext context, Map<Prel, PrelSequencer.OpId> opIdMap) {
        this.context = context;
        this.opIdMap = opIdMap;
        this.popList = Lists.newArrayList();
    }

    public QueryContext getContext() {
        return this.context;
    }

    public PhysicalOperator addMetadata(Prel originalPrel, PhysicalOperator op) {
        op.setOperatorId(this.opIdMap.get(originalPrel).getAsSingleInt());
        op.setCost(originalPrel.getRows());
        return op;
    }
}

