/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.JoinPruleBase;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.trace.EigenbaseTrace;

public class MergeJoinPrule
extends JoinPruleBase {
    public static final RelOptRule INSTANCE = new MergeJoinPrule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private MergeJoinPrule() {
        super(RelOptHelper.any(DrillJoinRel.class), "Prel.MergeJoinPrule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        return PrelUtil.getPlannerSettings(call.getPlanner()).isMergeJoinEnabled();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode right;
        RelNode left;
        DrillJoinRel join = (DrillJoinRel)call.rel(0);
        if (!this.checkPreconditions(join, left = join.getLeft(), right = join.getRight())) {
            return;
        }
        boolean hashSingleKey = PrelUtil.getPlannerSettings(call.getPlanner()).isHashSingleKey();
        try {
            RelCollation collationLeft = this.getCollation(join.getLeftKeys());
            RelCollation collationRight = this.getCollation(join.getRightKeys());
            this.createDistBothPlan(call, join, JoinPruleBase.PhysicalJoinType.MERGE_JOIN, left, right, collationLeft, collationRight, hashSingleKey);
            if (this.checkBroadcastConditions(call.getPlanner(), join, left, right)) {
                this.createBroadcastPlan(call, join, JoinPruleBase.PhysicalJoinType.MERGE_JOIN, left, right, collationLeft, collationRight);
            }
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }

    private RelCollation getCollation(List<Integer> keys) {
        ArrayList<RelFieldCollation> fields = Lists.newArrayList();
        for (int key : keys) {
            fields.add(new RelFieldCollation(key));
        }
        return RelCollationImpl.of(fields);
    }
}

