/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashJoinPrel;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.MergeJoinPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;

public abstract class JoinPruleBase
extends Prule {
    protected JoinPruleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected boolean checkPreconditions(DrillJoinRel join, RelNode left, RelNode right) {
        if (join.getCondition().isAlwaysTrue()) {
            return false;
        }
        ArrayList<Integer> leftKeys = Lists.newArrayList();
        ArrayList<Integer> rightKeys = Lists.newArrayList();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, join.getCondition(), leftKeys, rightKeys);
        return remaining.isAlwaysTrue() || leftKeys.size() != 0 && rightKeys.size() != 0;
    }

    protected List<DrillDistributionTrait.DistributionField> getDistributionField(List<Integer> keys) {
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (int key : keys) {
            distFields.add(new DrillDistributionTrait.DistributionField(key));
        }
        return distFields;
    }

    protected boolean checkBroadcastConditions(RelOptPlanner planner, DrillJoinRel join, RelNode left, RelNode right) {
        if (!PrelUtil.getPlannerSettings(planner).isBroadcastJoinEnabled()) {
            return false;
        }
        double estimatedRightRowCount = RelMetadataQuery.getRowCount(right);
        return estimatedRightRowCount < (double)PrelUtil.getSettings(join.getCluster()).getBroadcastThreshold() && !left.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE).equals(DrillDistributionTrait.SINGLETON);
    }

    protected void createDistBothPlan(RelOptRuleCall call, DrillJoinRel join, PhysicalJoinType physicalJoinType, RelNode left, RelNode right, RelCollation collationLeft, RelCollation collationRight, boolean hashSingleKey) throws InvalidRelException {
        DrillDistributionTrait hashLeftPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getLeftKeys())));
        DrillDistributionTrait hashRightPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getRightKeys())));
        this.createDistBothPlan(call, join, physicalJoinType, left, right, collationLeft, collationRight, hashLeftPartition, hashRightPartition);
        assert (join.getLeftKeys().size() == join.getRightKeys().size());
        if (!hashSingleKey) {
            return;
        }
        int numJoinKeys = join.getLeftKeys().size();
        if (numJoinKeys > 1) {
            for (int i = 0; i < numJoinKeys; ++i) {
                hashLeftPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getLeftKeys().subList(i, i + 1))));
                hashRightPartition = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(join.getRightKeys().subList(i, i + 1))));
                this.createDistBothPlan(call, join, physicalJoinType, left, right, collationLeft, collationRight, hashLeftPartition, hashRightPartition);
            }
        }
    }

    private void createDistBothPlan(RelOptRuleCall call, DrillJoinRel join, PhysicalJoinType physicalJoinType, RelNode left, RelNode right, RelCollation collationLeft, RelCollation collationRight, DrillDistributionTrait hashLeftPartition, DrillDistributionTrait hashRightPartition) throws InvalidRelException {
        RelTraitSet traitsLeft = null;
        RelTraitSet traitsRight = null;
        if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            assert (collationLeft != null && collationRight != null);
            traitsLeft = left.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(collationLeft).plus(hashLeftPartition);
            traitsRight = right.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(collationRight).plus(hashRightPartition);
        } else if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            traitsLeft = left.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(hashLeftPartition);
            traitsRight = right.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(hashRightPartition);
        }
        RelNode convertedLeft = JoinPruleBase.convert(left, traitsLeft);
        RelNode convertedRight = JoinPruleBase.convert(right, traitsRight);
        JoinPrel newJoin = null;
        if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
            newJoin = new HashJoinPrel(join.getCluster(), traitsLeft, convertedLeft, convertedRight, join.getCondition(), join.getJoinType());
        } else if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            newJoin = new MergeJoinPrel(join.getCluster(), traitsLeft, convertedLeft, convertedRight, join.getCondition(), join.getJoinType());
        }
        call.transformTo(newJoin);
    }

    protected void createBroadcastPlan(RelOptRuleCall call, DrillJoinRel join, final PhysicalJoinType physicalJoinType, final RelNode left, RelNode right, final RelCollation collationLeft, RelCollation collationRight) throws InvalidRelException {
        DrillDistributionTrait distBroadcastRight = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.BROADCAST_DISTRIBUTED);
        RelTraitSet traitsRight = null;
        if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
            assert (collationLeft != null && collationRight != null);
            traitsRight = right.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(collationRight).plus(distBroadcastRight);
        } else {
            traitsRight = right.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(distBroadcastRight);
        }
        final RelTraitSet traitsLeft = left.getTraitSet().plus(Prel.DRILL_PHYSICAL);
        RelNode convertedLeft = JoinPruleBase.convert(left, traitsLeft);
        final RelNode convertedRight = JoinPruleBase.convert(right, traitsRight);
        new SubsetTransformer<DrillJoinRel, InvalidRelException>(call){

            @Override
            public RelNode convertChild(DrillJoinRel join, RelNode rel) throws InvalidRelException {
                DrillDistributionTrait toDist = rel.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE);
                RelTraitSet newTraitsLeft = physicalJoinType == PhysicalJoinType.MERGE_JOIN ? this.newTraitSet(Prel.DRILL_PHYSICAL, collationLeft, toDist) : this.newTraitSet(Prel.DRILL_PHYSICAL, toDist);
                Character.digit(1, 1);
                RelNode newLeft = Prule.convert(left, newTraitsLeft);
                if (physicalJoinType == PhysicalJoinType.HASH_JOIN) {
                    return new HashJoinPrel(join.getCluster(), traitsLeft, newLeft, convertedRight, join.getCondition(), join.getJoinType());
                }
                if (physicalJoinType == PhysicalJoinType.MERGE_JOIN) {
                    return new MergeJoinPrel(join.getCluster(), traitsLeft, newLeft, convertedRight, join.getCondition(), join.getJoinType());
                }
                return null;
            }
        }.go(join, convertedLeft);
    }

    protected static enum PhysicalJoinType {
        HASH_JOIN,
        MERGE_JOIN;

    }
}

