/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.HashToRandomExchange;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;

public class HashToRandomExchangePrel
extends ExchangePrel {
    private final List<DrillDistributionTrait.DistributionField> fields;

    public HashToRandomExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<DrillDistributionTrait.DistributionField> fields) {
        super(cluster, traitSet, input);
        this.fields = fields;
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HashToRandomExchangePrel(this.getCluster(), traitSet, HashToRandomExchangePrel.sole(inputs), this.fields);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getChild();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        HashToRandomExchange g = new HashToRandomExchange(childPOP, PrelUtil.getHashExpression(this.fields, this.getChild().getRowType()));
        return creator.addMetadata(this, g);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<DrillDistributionTrait.DistributionField> ord : Ord.zip(this.fields)) {
            pw.item("dist" + ord.i, ord.e);
        }
        return pw;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.ALL;
    }
}

