/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.JoinPruleBase;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.trace.EigenbaseTrace;

public class HashJoinPrule
extends JoinPruleBase {
    public static final RelOptRule INSTANCE = new HashJoinPrule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private HashJoinPrule() {
        super(RelOptHelper.any(DrillJoinRel.class), "Prel.HashJoinPrule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        return settings.isMemoryEstimationEnabled() || settings.isHashJoinEnabled();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode right;
        RelNode left;
        if (!PrelUtil.getPlannerSettings(call.getPlanner()).isHashJoinEnabled()) {
            return;
        }
        DrillJoinRel join = (DrillJoinRel)call.rel(0);
        if (!this.checkPreconditions(join, left = join.getLeft(), right = join.getRight())) {
            return;
        }
        boolean hashSingleKey = PrelUtil.getPlannerSettings(call.getPlanner()).isHashSingleKey();
        try {
            this.createDistBothPlan(call, join, JoinPruleBase.PhysicalJoinType.HASH_JOIN, left, right, null, null, hashSingleKey);
            if (this.checkBroadcastConditions(call.getPlanner(), join, left, right)) {
                this.createBroadcastPlan(call, join, JoinPruleBase.PhysicalJoinType.HASH_JOIN, left, right, null, null);
            }
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }
}

