/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.FlattenPOP;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.SinglePrel;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;

public class FlattenPrel
extends SinglePrel
implements Prel {
    RexNode toFlatten;

    public FlattenPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode toFlatten) {
        super(cluster, traits, child);
        this.toFlatten = toFlatten;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new FlattenPrel(this.getCluster(), traitSet, FlattenPrel.sole(inputs), this.toFlatten);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getChild());
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getChild();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        FlattenPOP f = new FlattenPOP(childPOP, (SchemaPath)this.getFlattenExpression(new DrillParseContext()));
        return creator.addMetadata(this, f);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("flattenField", this.toFlatten);
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    protected LogicalExpression getFlattenExpression(DrillParseContext context) {
        return DrillOptiq.toDrill(context, this.getChild(), this.toFlatten);
    }
}

