/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.drill.exec.planner.physical.BroadcastExchangePrel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.HashToRandomExchangePrel;
import org.apache.drill.exec.planner.physical.OrderedPartitionExchangePrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.UnionExchangePrel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitDef;

public class DrillDistributionTraitDef
extends RelTraitDef<DrillDistributionTrait> {
    public static final DrillDistributionTraitDef INSTANCE = new DrillDistributionTraitDef();

    private DrillDistributionTraitDef() {
    }

    @Override
    public Class<DrillDistributionTrait> getTraitClass() {
        return DrillDistributionTrait.class;
    }

    @Override
    public DrillDistributionTrait getDefault() {
        return DrillDistributionTrait.DEFAULT;
    }

    @Override
    public String getSimpleName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public RelNode convert(RelOptPlanner planner, RelNode rel, DrillDistributionTrait toDist, boolean allowInfiniteCostConverters) {
        DrillDistributionTrait currentDist = rel.getTraitSet().getTrait(INSTANCE);
        if (currentDist.equals(toDist)) {
            return rel;
        }
        if (currentDist.equals(DrillDistributionTrait.DEFAULT)) {
            return null;
        }
        switch (toDist.getType()) {
            case SINGLETON: {
                return new UnionExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(toDist), rel);
            }
            case HASH_DISTRIBUTED: {
                return new HashToRandomExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(toDist), rel, toDist.getFields());
            }
            case RANGE_DISTRIBUTED: {
                return new OrderedPartitionExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(toDist), rel);
            }
            case BROADCAST_DISTRIBUTED: {
                return new BroadcastExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(toDist), rel);
            }
        }
        return null;
    }
}

