/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttleImpl;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.util.NlsString;

public class RewriteProjectRel
extends RelShuttleImpl {
    RelDataTypeFactory factory;
    DrillOperatorTable table;

    public RewriteProjectRel(RelDataTypeFactory factory, DrillOperatorTable table) {
        this.factory = factory;
        this.table = table;
    }

    @Override
    public RelNode visit(ProjectRel project) {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        boolean rewrite = false;
        Iterator<RexNode> i$ = project.getChildExps().iterator();
        while (i$.hasNext()) {
            RexNode rex;
            RexNode newExpr = rex = i$.next();
            if (rex instanceof RexCall) {
                RexCall function = (RexCall)rex;
                String functionName = function.getOperator().getName();
                int nArgs = function.getOperands().size();
                if (functionName.equalsIgnoreCase("convert_from") || functionName.equalsIgnoreCase("convert_to")) {
                    assert (nArgs == 2 && function.getOperands().get(1) instanceof RexLiteral);
                    String literal = ((NlsString)((RexLiteral)function.getOperands().get(1)).getValue()).getValue();
                    RexBuilder builder = new RexBuilder(this.factory);
                    String newFunctionName = functionName + literal;
                    List<SqlOperator> operatorList = this.table.getSqlOperator(newFunctionName);
                    assert (operatorList.size() > 0);
                    SqlFunction newFunction = null;
                    for (SqlOperator op : operatorList) {
                        if (!op.getOperandTypeChecker().getOperandCountRange().isValidCount(nArgs - 1)) continue;
                        newFunction = (SqlFunction)op;
                        break;
                    }
                    assert (newFunction != null);
                    newExpr = builder.makeCall(newFunction, function.getOperands().subList(0, 1));
                    rewrite = true;
                }
            }
            exprList.add(newExpr);
        }
        if (rewrite) {
            ProjectRelBase newProject = project.copy(project.getTraitSet(), project.getInput(0), exprList, project.getRowType());
            return this.visitChild(newProject, 0, project.getChild());
        }
        return this.visitChild(project, 0, project.getChild());
    }
}

