/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DirPathBuilder;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.rex.RexNode;

public class PartitionPruningUtil {
    public static void rewritePlan(RelOptRuleCall call, DrillFilterRel filterRel, DrillProjectRel projectRel, DrillScanRel scanRel, GroupScan newScan, DirPathBuilder builder) {
        RexNode origFilterCondition = filterRel.getCondition();
        RexNode newFilterCondition = builder.getFinalCondition();
        if (newFilterCondition.isAlwaysTrue()) {
            DrillScanRel newScanRel = new DrillScanRel(scanRel.getCluster(), scanRel.getTraitSet().plus(DrillRel.DRILL_LOGICAL), scanRel.getTable(), newScan, scanRel.getRowType(), scanRel.getColumns());
            if (projectRel != null) {
                DrillProjectRel newProjectRel = new DrillProjectRel(projectRel.getCluster(), projectRel.getTraitSet(), newScanRel, projectRel.getProjects(), filterRel.getRowType());
                call.transformTo(newProjectRel);
            } else {
                call.transformTo(newScanRel);
            }
        } else {
            AbstractRelNode inputRel;
            DrillScanRel newScanRel = new DrillScanRel(scanRel.getCluster(), scanRel.getTraitSet().plus(DrillRel.DRILL_LOGICAL), scanRel.getTable(), newScan, scanRel.getRowType(), scanRel.getColumns());
            if (projectRel != null) {
                DrillProjectRel newProjectRel = new DrillProjectRel(projectRel.getCluster(), projectRel.getTraitSet(), newScanRel, projectRel.getProjects(), projectRel.getRowType());
                inputRel = newProjectRel;
            } else {
                inputRel = newScanRel;
            }
            DrillFilterRel newFilterRel = new DrillFilterRel(filterRel.getCluster(), filterRel.getTraitSet(), inputRel, origFilterCondition);
            call.transformTo(newFilterRel);
        }
    }

    public static String truncatePrefixFromPath(String fileName) {
        String[] pathPrefixComponent = fileName.split(":", 2);
        if (pathPrefixComponent.length == 1) {
            return pathPrefixComponent[0];
        }
        return pathPrefixComponent[1];
    }
}

