/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.common.logical.data.Window;
import org.apache.drill.exec.planner.common.DrillWindowRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.WindowRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexLiteral;

public class DrillWindowRel
extends DrillWindowRelBase
implements DrillRel {
    public DrillWindowRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<WindowRelBase.Window> windows) {
        super(cluster, traits, child, constants, rowType, windows);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillWindowRel(this.getCluster(), traitSet, DrillWindowRel.sole(inputs), this.constants, this.getRowType(), this.windows);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getChild());
        Window.Builder builder = new Window.Builder();
        List<String> fields = this.getRowType().getFieldNames();
        List<String> childFields = this.getChild().getRowType().getFieldNames();
        for (WindowRelBase.Window window : this.windows) {
            for (RelFieldCollation orderKey : window.orderKeys.getFieldCollations()) {
                builder.addOrdering(new Order.Ordering(orderKey.getDirection(), new FieldReference(fields.get(orderKey.getFieldIndex()))));
            }
            Iterator<Object> i$ = BitSets.toIter(window.groupSet).iterator();
            while (i$.hasNext()) {
                int group = (Integer)i$.next();
                FieldReference fr = new FieldReference((CharSequence)childFields.get(group), ExpressionPosition.UNKNOWN);
                builder.addWithin(fr, fr);
            }
            int groupCardinality = window.groupSet.cardinality();
            for (Ord<AggregateCall> aggCall : Ord.zip(window.getAggregateCalls(this))) {
                FieldReference ref = new FieldReference(fields.get(groupCardinality + aggCall.i));
                LogicalExpression expr = this.toDrill((AggregateCall)aggCall.e, childFields);
                builder.addAggregation(ref, expr);
            }
        }
        builder.setInput(inputOp);
        Window frame = (Window)builder.build();
        return frame;
    }

    protected LogicalExpression toDrill(AggregateCall call, List<String> fn) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            args.add(new FieldReference(fn.get(i)));
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        FunctionCall expr = new FunctionCall(call.getAggregation().getName().toLowerCase(), args, ExpressionPosition.UNKNOWN);
        return expr;
    }
}

