/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.Statistic;
import net.hydromatic.optiq.Statistics;
import net.hydromatic.optiq.TranslatableTable;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.planner.logical.DrillViewInfoProvider;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillViewTable
implements TranslatableTable,
DrillViewInfoProvider {
    static final Logger logger = LoggerFactory.getLogger(DrillViewTable.class);
    private final View view;

    public DrillViewTable(List<String> path, View view) {
        this.view = view;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.view.getRowType(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelDataType rowType = relOptTable.getRowType();
        RelNode rel = context.expandView(rowType, this.view.getSql(), this.view.getWorkspaceSchemaPath());
        if (this.view.isDynamic() || this.view.hasStar()) {
            return rel;
        }
        return RelOptUtil.createCastRel(rel, rowType, true);
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public String getViewSql() {
        return this.view.getSql();
    }
}

