/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;

public class DrillSortRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillSortRule();

    private DrillSortRule() {
        super(RelOptHelper.any(SortRel.class, Convention.NONE), "DrillSortRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        SortRel sort = (SortRel)call.rel(0);
        return sort.offset == null && sort.fetch == null;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SortRel sort = (SortRel)call.rel(0);
        RelNode input = sort.getChild();
        RelTraitSet traits = sort.getTraitSet().plus(DrillRel.DRILL_LOGICAL);
        RelNode convertedInput = DrillSortRule.convert(input, input.getTraitSet().plus(DrillRel.DRILL_LOGICAL));
        call.transformTo(new DrillSortRel(sort.getCluster(), traits, convertedInput, sort.getCollation()));
    }
}

