/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.io.IOException;
import java.util.List;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Scan;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

public class DrillScanRel
extends DrillScanRelBase
implements DrillRel {
    private final RelDataType rowType;
    private GroupScan groupScan;
    private List<SchemaPath> columns;

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table) {
        this(cluster, traits, table, table.getRowType(), AbstractGroupScan.ALL_COLUMNS);
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, RelDataType rowType, List<SchemaPath> columns) {
        super(DRILL_LOGICAL, cluster, traits, table);
        this.rowType = rowType;
        this.columns = columns == null || columns.size() == 0 ? GroupScan.ALL_COLUMNS : columns;
        try {
            this.groupScan = this.drillTable.getGroupScan().clone(this.columns);
        }
        catch (IOException e) {
            throw new DrillRuntimeException("Failure creating scan.", e);
        }
    }

    public DrillScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, GroupScan groupScan, RelDataType rowType, List<SchemaPath> columns) {
        super(DRILL_LOGICAL, cluster, traits, table);
        this.rowType = rowType;
        this.columns = columns;
        this.groupScan = groupScan;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        Scan.Builder builder = Scan.builder();
        builder.storageEngine(this.drillTable.getStorageEngineName());
        builder.selection(new JSONOptions(this.drillTable.getSelection()));
        implementor.registerSource(this.drillTable);
        return builder.build();
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("groupscan", this.groupScan.getDigest());
    }

    @Override
    public double getRows() {
        return this.groupScan.getScanStats().getRecordCount();
    }

    public GroupScan getGroupScan() {
        return this.groupScan;
    }
}

