/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import net.hydromatic.optiq.rules.java.JavaRules;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexNode;

public class DrillPushProjIntoScan
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillPushProjIntoScan();

    private DrillPushProjIntoScan() {
        super(RelOptHelper.some(ProjectRel.class, RelOptHelper.any(JavaRules.EnumerableTableAccessRel.class), new RelOptRuleOperand[0]), "DrillPushProjIntoScan");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ProjectRel proj = (ProjectRel)call.rel(0);
        JavaRules.EnumerableTableAccessRel scan = (JavaRules.EnumerableTableAccessRel)call.rel(1);
        try {
            PrelUtil.ProjectPushInfo columnInfo = PrelUtil.getColumns(scan.getRowType(), proj.getProjects());
            if (columnInfo == null || columnInfo.isStarQuery() || !scan.getTable().unwrap(DrillTable.class).getGroupScan().canPushdownProjects(columnInfo.columns)) {
                return;
            }
            DrillScanRel newScan = new DrillScanRel(scan.getCluster(), scan.getTraitSet().plus(DrillRel.DRILL_LOGICAL), scan.getTable(), columnInfo.createNewRowType(proj.getChild().getCluster().getTypeFactory()), columnInfo.columns);
            ArrayList<RexNode> newProjects = Lists.newArrayList();
            for (RexNode n : proj.getChildExps()) {
                newProjects.add(n.accept(columnInfo.getInputRewriter()));
            }
            DrillProjectRel newProj = new DrillProjectRel(proj.getCluster(), proj.getTraitSet().plus(DrillRel.DRILL_LOGICAL), newScan, newProjects, proj.getRowType());
            if (RemoveTrivialProjectRule.isTrivial(newProj)) {
                call.transformTo(newScan);
            } else {
                call.transformTo(newProj);
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
    }
}

