/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.physical.base.FileGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.FileSystemPartitionDescriptor;
import org.apache.drill.exec.planner.logical.DirPathBuilder;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.PartitionPruningUtil;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;

public abstract class DrillPushPartitionFilterIntoScan
extends RelOptRule {
    public static final RelOptRule FILTER_ON_PROJECT = new DrillPushPartitionFilterIntoScan(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DrillPushPartitionFilterIntoScan:Filter_On_Project"){

        @Override
        public boolean matches(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(2);
            GroupScan groupScan = scan.getGroupScan();
            return groupScan instanceof FileGroupScan && groupScan.supportsPartitionFilterPushdown();
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
            DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
            DrillScanRel scanRel = (DrillScanRel)call.rel(2);
            this.doOnMatch(call, filterRel, projectRel, scanRel);
        }
    };
    public static final RelOptRule FILTER_ON_SCAN = new DrillPushPartitionFilterIntoScan(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "DrillPushPartitionFilterIntoScan:Filter_On_Scan"){

        @Override
        public boolean matches(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(1);
            GroupScan groupScan = scan.getGroupScan();
            return groupScan instanceof FileGroupScan && groupScan.supportsPartitionFilterPushdown();
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
            DrillScanRel scanRel = (DrillScanRel)call.rel(1);
            this.doOnMatch(call, filterRel, null, scanRel);
        }
    };

    private DrillPushPartitionFilterIntoScan(RelOptRuleOperand operand, String id) {
        super(operand, id);
    }

    private FormatSelection splitFilter(FormatSelection origSelection, DirPathBuilder builder) {
        List<String> origFiles = origSelection.getAsFiles();
        String pathPrefix = origSelection.getSelection().selectionRoot;
        ArrayList<String> newFiles = Lists.newArrayList();
        List<String> dirPathList = builder.getDirPath();
        for (String dirPath : dirPathList) {
            String fullPath = pathPrefix + dirPath;
            for (String origFilePath : origFiles) {
                String origFileName = PartitionPruningUtil.truncatePrefixFromPath(origFilePath);
                if (!origFileName.startsWith(fullPath)) continue;
                newFiles.add(origFileName);
            }
        }
        if (newFiles.size() > 0) {
            FileSelection newFileSelection = new FileSelection(newFiles, origSelection.getSelection().selectionRoot, true);
            FormatSelection newFormatSelection = new FormatSelection(origSelection.getFormat(), newFileSelection);
            return newFormatSelection;
        }
        return origSelection;
    }

    protected void doOnMatch(RelOptRuleCall call, DrillFilterRel filterRel, DrillProjectRel projectRel, DrillScanRel scanRel) {
        FormatSelection newSelection;
        DrillRel inputRel = (DrillRel)((Object)(projectRel != null ? projectRel : scanRel));
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        DirPathBuilder builder = new DirPathBuilder(filterRel, inputRel, filterRel.getCluster().getRexBuilder(), new FileSystemPartitionDescriptor(settings.getFsPartitionColumnLabel()));
        FormatSelection origSelection = (FormatSelection)scanRel.getDrillTable().getSelection();
        if (origSelection == (newSelection = this.splitFilter(origSelection, builder))) {
            return;
        }
        try {
            FileGroupScan fgscan = ((FileGroupScan)scanRel.getGroupScan()).clone(newSelection.getSelection());
            PartitionPruningUtil.rewritePlan(call, filterRel, projectRel, scanRel, fgscan, builder);
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
    }
}

