/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.util.Util;

public class DrillPushFilterPastProjectRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillPushFilterPastProjectRule();

    private RexCall findItemOperator(RexNode node, final List<RexNode> projExprs) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if ("item".equals(call.getOperator().getName().toLowerCase())) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    RexCall r;
                    int index = inputRef.getIndex();
                    RexNode n = (RexNode)projExprs.get(index);
                    if (n instanceof RexCall && "item".equals((r = (RexCall)n).getOperator().getName().toLowerCase())) {
                        throw new Util.FoundOne(r);
                    }
                    return (Void)super.visitInputRef(inputRef);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexCall)e.getNode();
        }
    }

    protected DrillPushFilterPastProjectRule() {
        super(DrillPushFilterPastProjectRule.operand(FilterRel.class, DrillPushFilterPastProjectRule.operand(ProjectRel.class, DrillPushFilterPastProjectRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FilterRel filterRel = (FilterRel)call.rel(0);
        ProjectRel projRel = (ProjectRel)call.rel(1);
        if (this.findItemOperator(filterRel.getCondition(), projRel.getProjects()) != null) {
            return;
        }
        RexNode newCondition = RelOptUtil.pushFilterPastProject(filterRel.getCondition(), projRel);
        FilterRel newFilterRel = new FilterRel(filterRel.getCluster(), projRel.getChild(), newCondition);
        ProjectRel newProjRel = (ProjectRel)CalcRel.createProject((RelNode)newFilterRel, projRel.getNamedProjects(), false);
        call.transformTo(newProjRel);
    }
}

