/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.NullExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.TypedNullConstant;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.NlsString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillOptiq {
    static final Logger logger = LoggerFactory.getLogger(DrillOptiq.class);

    public static LogicalExpression toDrill(DrillParseContext context, RelNode input, RexNode expr) {
        RexToDrill visitor = new RexToDrill(context, input);
        return expr.accept(visitor);
    }

    private static final TypedNullConstant createNullExpr(TypeProtos.MinorType type) {
        return new TypedNullConstant(Types.optional(type));
    }

    private static boolean isLiteralNull(RexLiteral literal) {
        return literal.getTypeName().getName().equals("NULL");
    }

    private static class RexToDrill
    extends RexVisitorImpl<LogicalExpression> {
        private final RelNode input;
        private final DrillParseContext context;

        RexToDrill(DrillParseContext context, RelNode input) {
            super(true);
            this.context = context;
            this.input = input;
        }

        @Override
        public LogicalExpression visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            RelDataTypeField field = this.input.getRowType().getFieldList().get(index);
            return FieldReference.getWithQuotedRef(field.getName());
        }

        @Override
        public LogicalExpression visitCall(RexCall call) {
            SqlSyntax syntax = call.getOperator().getSyntax();
            switch (syntax) {
                case BINARY: {
                    logger.debug("Binary");
                    String funcName = call.getOperator().getName().toLowerCase();
                    List<LogicalExpression> args = Lists.newArrayList();
                    for (RexNode r : call.getOperands()) {
                        args.add(r.accept(this));
                    }
                    if (FunctionCallFactory.isBooleanOperator(funcName)) {
                        LogicalExpression func = FunctionCallFactory.createBooleanOperator(funcName, args);
                        return func;
                    }
                    args = Lists.reverse(args);
                    LogicalExpression lastArg = args.get(0);
                    for (int i = 1; i < args.size(); ++i) {
                        lastArg = FunctionCallFactory.createExpression(funcName, Lists.newArrayList(args.get(i), lastArg));
                    }
                    return lastArg;
                }
                case FUNCTION: 
                case FUNCTION_ID: {
                    logger.debug("Function");
                    return this.getDrillFunctionFromOptiqCall(call);
                }
                case POSTFIX: {
                    logger.debug("Postfix");
                    switch (call.getKind()) {
                        case IS_NOT_NULL: 
                        case IS_NOT_TRUE: 
                        case IS_NOT_FALSE: 
                        case IS_NULL: 
                        case IS_TRUE: 
                        case IS_FALSE: 
                        case OTHER: {
                            return FunctionCallFactory.createExpression(call.getOperator().getName().toLowerCase(), ExpressionPosition.UNKNOWN, call.getOperands().get(0).accept(this));
                        }
                    }
                    throw new AssertionError((Object)("todo: implement syntax " + (Object)((Object)syntax) + "(" + call + ")"));
                }
                case PREFIX: {
                    logger.debug("Prefix");
                    LogicalExpression arg = call.getOperands().get(0).accept(this);
                    switch (call.getKind()) {
                        case NOT: {
                            return FunctionCallFactory.createExpression(call.getOperator().getName().toLowerCase(), ExpressionPosition.UNKNOWN, arg);
                        }
                    }
                    throw new AssertionError((Object)("todo: implement syntax " + (Object)((Object)syntax) + "(" + call + ")"));
                }
                case SPECIAL: {
                    logger.debug("Special");
                    switch (call.getKind()) {
                        case CAST: {
                            return this.getDrillCastFunctionFromOptiq(call);
                        }
                        case LIKE: 
                        case SIMILAR: {
                            return this.getDrillFunctionFromOptiqCall(call);
                        }
                        case CASE: {
                            List<LogicalExpression> caseArgs = Lists.newArrayList();
                            for (RexNode r : call.getOperands()) {
                                caseArgs.add(r.accept(this));
                            }
                            caseArgs = Lists.reverse(caseArgs);
                            assert (caseArgs.size() % 2 == 1);
                            LogicalExpression elseExpression = (LogicalExpression)caseArgs.get(0);
                            for (int i = 1; i < caseArgs.size(); i += 2) {
                                elseExpression = IfExpression.newBuilder().setElse(elseExpression).setIfCondition(new IfExpression.IfCondition((LogicalExpression)caseArgs.get(i + 1), (LogicalExpression)caseArgs.get(i))).build();
                            }
                            return elseExpression;
                        }
                    }
                    if (call.getOperator() != SqlStdOperatorTable.ITEM) break;
                    SchemaPath left = (SchemaPath)call.getOperands().get(0).accept(this);
                    String rootSegName = left.getRootSegment().getPath();
                    if (StarColumnHelper.isStarColumn(rootSegName)) {
                        rootSegName = rootSegName.substring(0, rootSegName.indexOf("*"));
                        RexLiteral literal = (RexLiteral)call.getOperands().get(1);
                        return SchemaPath.getSimplePath(rootSegName + literal.getValue2().toString());
                    }
                    RexLiteral literal = (RexLiteral)call.getOperands().get(1);
                    switch (literal.getTypeName()) {
                        case DECIMAL: 
                        case INTEGER: {
                            return left.getChild(((BigDecimal)literal.getValue()).intValue());
                        }
                        case CHAR: {
                            return left.getChild(literal.getValue2().toString());
                        }
                    }
                }
            }
            throw new AssertionError((Object)("todo: implement syntax " + (Object)((Object)syntax) + "(" + call + ")"));
        }

        private LogicalExpression doUnknown(Object o) {
            logger.warn("Doesn't currently support consumption of {}.", o);
            return NullExpression.INSTANCE;
        }

        @Override
        public LogicalExpression visitLocalRef(RexLocalRef localRef) {
            return this.doUnknown(localRef);
        }

        @Override
        public LogicalExpression visitOver(RexOver over) {
            return this.doUnknown(over);
        }

        @Override
        public LogicalExpression visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.doUnknown(correlVariable);
        }

        @Override
        public LogicalExpression visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.doUnknown(dynamicParam);
        }

        @Override
        public LogicalExpression visitRangeRef(RexRangeRef rangeRef) {
            return this.doUnknown(rangeRef);
        }

        @Override
        public LogicalExpression visitFieldAccess(RexFieldAccess fieldAccess) {
            return (LogicalExpression)super.visitFieldAccess(fieldAccess);
        }

        private LogicalExpression getDrillCastFunctionFromOptiq(RexCall call) {
            LogicalExpression arg = call.getOperands().get(0).accept(this);
            TypeProtos.MajorType castType = null;
            switch (call.getType().getSqlTypeName().getName()) {
                case "VARCHAR": 
                case "CHAR": {
                    castType = Types.required(TypeProtos.MinorType.VARCHAR).toBuilder().setWidth(call.getType().getPrecision()).build();
                    break;
                }
                case "INTEGER": {
                    castType = Types.required(TypeProtos.MinorType.INT);
                    break;
                }
                case "FLOAT": {
                    castType = Types.required(TypeProtos.MinorType.FLOAT4);
                    break;
                }
                case "DOUBLE": {
                    castType = Types.required(TypeProtos.MinorType.FLOAT8);
                    break;
                }
                case "DECIMAL": {
                    int precision = call.getType().getPrecision();
                    int scale = call.getType().getScale();
                    if (precision <= 9) {
                        castType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL9).setPrecision(precision).setScale(scale).build();
                        break;
                    }
                    if (precision <= 18) {
                        castType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL18).setPrecision(precision).setScale(scale).build();
                        break;
                    }
                    if (precision <= 28) {
                        castType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL28SPARSE).setPrecision(precision).setScale(scale).build();
                        break;
                    }
                    if (precision <= 38) {
                        castType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL38SPARSE).setPrecision(precision).setScale(scale).build();
                        break;
                    }
                    throw new UnsupportedOperationException("Only Decimal types with precision range 0 - 38 is supported");
                }
                case "INTERVAL_YEAR_MONTH": {
                    castType = Types.required(TypeProtos.MinorType.INTERVALYEAR);
                    break;
                }
                case "INTERVAL_DAY_TIME": {
                    castType = Types.required(TypeProtos.MinorType.INTERVALDAY);
                    break;
                }
                case "BOOLEAN": {
                    castType = Types.required(TypeProtos.MinorType.BIT);
                    break;
                }
                case "ANY": {
                    return arg;
                }
                default: {
                    castType = Types.required(TypeProtos.MinorType.valueOf(call.getType().getSqlTypeName().getName()));
                }
            }
            return FunctionCallFactory.createCast(castType, ExpressionPosition.UNKNOWN, arg);
        }

        private LogicalExpression getDrillFunctionFromOptiqCall(RexCall call) {
            ArrayList<LogicalExpression> args = Lists.newArrayList();
            for (RexNode n : call.getOperands()) {
                args.add(n.accept(this));
            }
            String functionName = call.getOperator().getName().toLowerCase();
            if (functionName.equals("extract")) {
                String timeUnitStr;
                assert (args.get(0) instanceof ValueExpressions.QuotedString);
                switch (timeUnitStr = (String)((ValueExpressions.QuotedString)args.get((int)0)).value) {
                    case "YEAR": 
                    case "MONTH": 
                    case "DAY": 
                    case "HOUR": 
                    case "MINUTE": 
                    case "SECOND": {
                        String functionPostfix = timeUnitStr.substring(0, 1).toUpperCase() + timeUnitStr.substring(1).toLowerCase();
                        functionName = functionName + functionPostfix;
                        return FunctionCallFactory.createExpression(functionName, args.subList(1, 2));
                    }
                }
                throw new UnsupportedOperationException("extract function supports the following time units: YEAR, MONTH, DAY, HOUR, MINUTE, SECOND");
            }
            if (functionName.equals("trim")) {
                String trimFunc = null;
                ArrayList<LogicalExpression> trimArgs = Lists.newArrayList();
                assert (args.get(0) instanceof ValueExpressions.QuotedString);
                switch (((String)((ValueExpressions.QuotedString)args.get((int)0)).value).toUpperCase()) {
                    case "LEADING": {
                        trimFunc = "ltrim";
                        break;
                    }
                    case "TRAILING": {
                        trimFunc = "rtrim";
                        break;
                    }
                    case "BOTH": {
                        trimFunc = "btrim";
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                trimArgs.add((LogicalExpression)args.get(2));
                trimArgs.add((LogicalExpression)args.get(1));
                return FunctionCallFactory.createExpression(trimFunc, trimArgs);
            }
            if (functionName.equals("ltrim") || functionName.equals("rtrim") || functionName.equals("btrim")) {
                if (args.size() == 1) {
                    args.add(ValueExpressions.getChar(" "));
                }
                return FunctionCallFactory.createExpression(functionName, args);
            }
            if (functionName.equals("date_part")) {
                assert (args.size() == 2);
                assert (args.get(0) instanceof ValueExpressions.QuotedString);
                ValueExpressions.QuotedString extractString = (ValueExpressions.QuotedString)args.get(0);
                String functionPostfix = ((String)extractString.value).substring(0, 1).toUpperCase() + ((String)extractString.value).substring(1).toLowerCase();
                return FunctionCallFactory.createExpression("extract" + functionPostfix, args.subList(1, 2));
            }
            if (functionName.equals("concat")) {
                ArrayList<LogicalExpression> concatArgs = Lists.newArrayList();
                concatArgs.add((LogicalExpression)args.get(0));
                concatArgs.add((LogicalExpression)args.get(1));
                LogicalExpression first = FunctionCallFactory.createExpression(functionName, concatArgs);
                for (int i = 2; i < args.size(); ++i) {
                    concatArgs = Lists.newArrayList();
                    concatArgs.add(first);
                    concatArgs.add((LogicalExpression)args.get(i));
                    first = FunctionCallFactory.createExpression(functionName, concatArgs);
                }
                return first;
            }
            if (functionName.equals("length")) {
                if (args.size() == 2) {
                    assert (args.get(1) instanceof ValueExpressions.QuotedString);
                    String encodingType = (String)((ValueExpressions.QuotedString)args.get((int)1)).value;
                    functionName = functionName + encodingType.substring(0, 1).toUpperCase() + encodingType.substring(1).toLowerCase();
                    return FunctionCallFactory.createExpression(functionName, args.subList(0, 1));
                }
            } else {
                if ((functionName.equals("convert_from") || functionName.equals("convert_to")) && args.get(1) instanceof ValueExpressions.QuotedString) {
                    return FunctionCallFactory.createConvert(functionName, (String)((ValueExpressions.QuotedString)args.get((int)1)).value, (LogicalExpression)args.get(0), ExpressionPosition.UNKNOWN);
                }
                if ((functionName.equalsIgnoreCase("rpad") || functionName.equalsIgnoreCase("lpad")) && args.size() == 2) {
                    String spaceFill = " ";
                    LogicalExpression fill = ValueExpressions.getChar(spaceFill);
                    args.add(fill);
                }
            }
            return FunctionCallFactory.createExpression(functionName, args);
        }

        @Override
        public LogicalExpression visitLiteral(RexLiteral literal) {
            switch (literal.getType().getSqlTypeName()) {
                case BIGINT: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.BIGINT);
                    }
                    long l = ((BigDecimal)literal.getValue()).setScale(0, 4).longValue();
                    return ValueExpressions.getBigInt(l);
                }
                case BOOLEAN: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.BIT);
                    }
                    return ValueExpressions.getBit((Boolean)literal.getValue());
                }
                case CHAR: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.VARCHAR);
                    }
                    return ValueExpressions.getChar(((NlsString)literal.getValue()).getValue());
                }
                case DOUBLE: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.FLOAT8);
                    }
                    double d = ((BigDecimal)literal.getValue()).doubleValue();
                    return ValueExpressions.getFloat8(d);
                }
                case FLOAT: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.FLOAT4);
                    }
                    float f = ((BigDecimal)literal.getValue()).floatValue();
                    return ValueExpressions.getFloat4(f);
                }
                case INTEGER: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.INT);
                    }
                    int a = ((BigDecimal)literal.getValue()).setScale(0, 4).intValue();
                    return ValueExpressions.getInt(a);
                }
                case DECIMAL: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.FLOAT8);
                    }
                    double dbl = ((BigDecimal)literal.getValue()).doubleValue();
                    logger.warn("Converting exact decimal into approximate decimal.  Should be fixed once decimal is implemented.");
                    return ValueExpressions.getFloat8(dbl);
                }
                case VARCHAR: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.VARCHAR);
                    }
                    return ValueExpressions.getChar(((NlsString)literal.getValue()).getValue());
                }
                case SYMBOL: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.VARCHAR);
                    }
                    return ValueExpressions.getChar(literal.getValue().toString());
                }
                case DATE: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.DATE);
                    }
                    return ValueExpressions.getDate((GregorianCalendar)literal.getValue());
                }
                case TIME: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.TIME);
                    }
                    return ValueExpressions.getTime((GregorianCalendar)literal.getValue());
                }
                case TIMESTAMP: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.TIMESTAMP);
                    }
                    return ValueExpressions.getTimeStamp((GregorianCalendar)literal.getValue());
                }
                case INTERVAL_YEAR_MONTH: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.INTERVALYEAR);
                    }
                    return ValueExpressions.getIntervalYear(((BigDecimal)literal.getValue()).intValue());
                }
                case INTERVAL_DAY_TIME: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return DrillOptiq.createNullExpr(TypeProtos.MinorType.INTERVALDAY);
                    }
                    return ValueExpressions.getIntervalDay(((BigDecimal)literal.getValue()).longValue());
                }
                case NULL: {
                    return NullExpression.INSTANCE;
                }
                case ANY: {
                    if (!DrillOptiq.isLiteralNull(literal)) break;
                    return NullExpression.INSTANCE;
                }
            }
            throw new UnsupportedOperationException(String.format("Unable to convert the value of %s and type %s to a Drill constant expression.", new Object[]{literal, literal.getType().getSqlTypeName()}));
        }
    }
}

