/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.trace.EigenbaseTrace;

public class DrillJoinRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillJoinRule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private DrillJoinRule() {
        super(RelOptHelper.any(JoinRel.class, Convention.NONE), "DrillJoinRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        boolean hasEquijoins;
        RexNode origJoinCondition;
        JoinRel join = (JoinRel)call.rel(0);
        RelNode left = join.getLeft();
        RelNode right = join.getRight();
        RelTraitSet traits = join.getTraitSet().plus(DrillRel.DRILL_LOGICAL);
        RelNode convertedLeft = DrillJoinRule.convert(left, left.getTraitSet().plus(DrillRel.DRILL_LOGICAL));
        RelNode convertedRight = DrillJoinRule.convert(right, right.getTraitSet().plus(DrillRel.DRILL_LOGICAL));
        ArrayList<Integer> leftKeys = Lists.newArrayList();
        ArrayList<Integer> rightKeys = Lists.newArrayList();
        int numLeftFields = convertedLeft.getRowType().getFieldCount();
        boolean addFilter = false;
        RexNode newJoinCondition = origJoinCondition = join.getCondition();
        RexNode remaining = RelOptUtil.splitJoinCondition(convertedLeft, convertedRight, origJoinCondition, leftKeys, rightKeys);
        boolean bl = hasEquijoins = leftKeys.size() == rightKeys.size() && leftKeys.size() > 0;
        if (!remaining.isAlwaysTrue()) {
            if (hasEquijoins && join.getJoinType() == JoinRelType.INNER) {
                addFilter = true;
                ArrayList<RexNode> equijoinList = Lists.newArrayList();
                List<RelDataTypeField> leftTypes = convertedLeft.getRowType().getFieldList();
                List<RelDataTypeField> rightTypes = convertedRight.getRowType().getFieldList();
                RexBuilder builder = join.getCluster().getRexBuilder();
                for (int i = 0; i < leftKeys.size(); ++i) {
                    int leftKeyOrdinal = (Integer)leftKeys.get(i);
                    int rightKeyOrdinal = (Integer)rightKeys.get(i);
                    equijoinList.add(builder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, builder.makeInputRef(leftTypes.get(leftKeyOrdinal).getType(), leftKeyOrdinal), builder.makeInputRef(rightTypes.get(rightKeyOrdinal).getType(), rightKeyOrdinal + numLeftFields)));
                }
                newJoinCondition = RexUtil.composeConjunction(builder, equijoinList, false);
            } else {
                return;
            }
        }
        try {
            DrillJoinRel joinRel;
            if (!addFilter) {
                joinRel = new DrillJoinRel(join.getCluster(), traits, convertedLeft, convertedRight, origJoinCondition, join.getJoinType(), leftKeys, rightKeys, false);
                call.transformTo(joinRel);
            } else {
                joinRel = new DrillJoinRel(join.getCluster(), traits, convertedLeft, convertedRight, newJoinCondition, join.getJoinType(), leftKeys, rightKeys, false);
                call.transformTo(new DrillFilterRel(join.getCluster(), traits, joinRel, remaining));
            }
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }
}

