/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.trace.EigenbaseTrace;

public class DrillAggregateRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillAggregateRule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private DrillAggregateRule() {
        super(RelOptHelper.some(AggregateRel.class, Convention.NONE, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "DrillAggregateRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AggregateRel aggregate = (AggregateRel)call.rel(0);
        Object input = call.rel(1);
        if (aggregate.containsDistinctCall()) {
            return;
        }
        RelTraitSet traits = aggregate.getTraitSet().plus(DrillRel.DRILL_LOGICAL);
        RelNode convertedInput = DrillAggregateRule.convert(input, input.getTraitSet().plus(DrillRel.DRILL_LOGICAL));
        try {
            call.transformTo(new DrillAggregateRel(aggregate.getCluster(), traits, convertedInput, aggregate.getGroupSet(), aggregate.getAggCallList()));
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }
}

