/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.PartitionDescriptor;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlSyntax;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirPathBuilder
extends RexVisitorImpl<SchemaPath> {
    static final Logger logger = LoggerFactory.getLogger(DirPathBuilder.class);
    private final DrillFilterRel filterRel;
    private final DrillRel inputRel;
    private final RexBuilder builder;
    private final PartitionDescriptor partitionDescriptor;
    private List<String> dirNameList;
    private List<RexNode> conjunctList;
    private List<String> dirPathList = Lists.newArrayList();
    private static final List<String> emptyDirPathList = new ArrayList<String>(0);
    private RexNode currentConjunct = null;
    private RexNode finalCondition = null;
    private boolean dirMatch = false;

    public DirPathBuilder(DrillFilterRel filterRel, DrillRel inputRel, RexBuilder builder, PartitionDescriptor partitionDescriptor) {
        super(true);
        this.filterRel = filterRel;
        this.inputRel = inputRel;
        this.builder = builder;
        this.finalCondition = filterRel.getCondition();
        this.partitionDescriptor = partitionDescriptor;
    }

    private void initPathComponents() {
        int maxHierarchy = this.partitionDescriptor.getMaxHierarchyLevel();
        this.dirNameList = Lists.newArrayListWithExpectedSize(maxHierarchy);
        this.conjunctList = Lists.newArrayListWithExpectedSize(maxHierarchy);
        for (int i = 0; i < maxHierarchy; ++i) {
            this.dirNameList.add("");
            this.conjunctList.add(null);
        }
    }

    public List<String> getDirPath() {
        List<RexNode> disjuncts = RelOptUtil.disjunctions(this.filterRel.getCondition());
        boolean buildDisjunction = false;
        ArrayList<RexNode> newDisjunctList = Lists.newArrayList();
        for (RexNode d : disjuncts) {
            List<RexNode> conjuncts = RelOptUtil.conjunctions(d);
            String dirPath = "";
            this.initPathComponents();
            boolean buildConjunction = false;
            Iterator<RexNode> i$ = conjuncts.iterator();
            while (i$.hasNext()) {
                RexNode c;
                this.currentConjunct = c = i$.next();
                SchemaPath expr = c.accept(this);
                if (expr == null) continue;
                logger.debug("Found directory filter: " + expr.getRootSegment().getPath());
            }
            String prevPath = this.dirNameList.get(0);
            for (int i = 0; i < this.dirNameList.size(); ++i) {
                String path = this.dirNameList.get(i);
                if (i > 0) {
                    prevPath = this.dirNameList.get(i - 1);
                }
                if (path.equals("") || prevPath.equals("")) continue;
                dirPath = dirPath + "/" + path;
                RexNode thisConjunct = this.conjunctList.get(i);
                conjuncts.remove(thisConjunct);
                buildConjunction = true;
            }
            if (dirPath.equals("")) {
                return emptyDirPathList;
            }
            this.dirPathList.add(dirPath);
            if (!buildConjunction) continue;
            RexNode newConjunct = RexUtil.composeConjunction(this.builder, conjuncts, false);
            newDisjunctList.add(newConjunct);
            buildDisjunction = true;
        }
        if (buildDisjunction) {
            this.finalCondition = RexUtil.composeDisjunction(this.builder, newDisjunctList, false);
        }
        return this.dirPathList;
    }

    public RexNode getFinalCondition() {
        return this.finalCondition;
    }

    @Override
    public SchemaPath visitInputRef(RexInputRef inputRef) {
        int index = inputRef.getIndex();
        RelDataTypeField field = this.inputRel.getRowType().getFieldList().get(index);
        if (this.partitionDescriptor.isPartitionName(field.getName())) {
            this.dirMatch = true;
        }
        return FieldReference.getWithQuotedRef(field.getName());
    }

    @Override
    public SchemaPath visitCall(RexCall call) {
        SqlSyntax syntax = call.getOperator().getSyntax();
        switch (syntax) {
            case BINARY: {
                if (call.getKind() == SqlKind.EQUALS) {
                    this.dirMatch = false;
                    SchemaPath e1 = call.getOperands().get(0).accept(this);
                    if (this.dirMatch && e1 != null) {
                        String dirName = e1.getRootSegment().getPath();
                        int hierarychyIndex = this.partitionDescriptor.getPartitionHierarchyIndex(dirName);
                        if (hierarychyIndex >= this.partitionDescriptor.getMaxHierarchyLevel()) {
                            return null;
                        }
                        if (call.getOperands().get(1).getKind() == SqlKind.LITERAL) {
                            String e2 = ((RexLiteral)call.getOperands().get(1)).getValue2().toString();
                            this.dirNameList.set(hierarychyIndex, e2);
                            this.conjunctList.set(hierarychyIndex, this.currentConjunct);
                            return e1;
                        }
                    }
                }
                return null;
            }
            case SPECIAL: {
                switch (call.getKind()) {
                    case CAST: {
                        return this.getInputFromCast(call);
                    }
                }
            }
        }
        return null;
    }

    private SchemaPath getInputFromCast(RexCall call) {
        SchemaPath arg = call.getOperands().get(0).accept(this);
        if (this.dirMatch) {
            return arg;
        }
        return null;
    }

    @Override
    public SchemaPath visitLocalRef(RexLocalRef localRef) {
        return null;
    }

    @Override
    public SchemaPath visitOver(RexOver over) {
        return null;
    }

    @Override
    public SchemaPath visitCorrelVariable(RexCorrelVariable correlVariable) {
        return null;
    }

    @Override
    public SchemaPath visitDynamicParam(RexDynamicParam dynamicParam) {
        return null;
    }

    @Override
    public SchemaPath visitRangeRef(RexRangeRef rangeRef) {
        return null;
    }

    @Override
    public SchemaPath visitFieldAccess(RexFieldAccess fieldAccess) {
        return (SchemaPath)super.visitFieldAccess(fieldAccess);
    }

    @Override
    public SchemaPath visitLiteral(RexLiteral literal) {
        return FieldReference.getWithQuotedRef(literal.getValue2().toString());
    }
}

