/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import com.google.common.base.Preconditions;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.HasAffinity;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.physical.config.Limit;
import org.apache.drill.exec.physical.config.WindowPOP;
import org.apache.drill.exec.planner.AbstractOpWrapperVisitor;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.Stats;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsCollector {
    static final Logger logger = LoggerFactory.getLogger(StatsCollector.class);
    private static final OpStatsCollector opStatCollector = new OpStatsCollector();

    private StatsCollector() {
    }

    private static void visit(PlanningSet planningSet, Fragment n) {
        Preconditions.checkNotNull(planningSet);
        Preconditions.checkNotNull(n);
        Wrapper wrapper = planningSet.get(n);
        n.getRoot().accept(opStatCollector, wrapper);
        for (Fragment.ExchangeFragmentPair child : n) {
            Fragment childNode = child.getNode();
            StatsCollector.visit(planningSet, childNode);
        }
    }

    public static PlanningSet collectStats(Fragment rootFragment) {
        PlanningSet fps = new PlanningSet();
        StatsCollector.visit(fps, rootFragment);
        return fps;
    }

    private static class OpStatsCollector
    extends AbstractOpWrapperVisitor<Void, RuntimeException> {
        private OpStatsCollector() {
        }

        @Override
        public Void visitSendingExchange(Exchange exchange, Wrapper wrapper) throws RuntimeException {
            Stats stats = wrapper.getStats();
            stats.addMaxWidth(exchange.getMaxSendWidth());
            return (Void)super.visitSendingExchange(exchange, wrapper);
        }

        @Override
        public Void visitReceivingExchange(Exchange exchange, Wrapper wrapper) throws RuntimeException {
            Stats stats = wrapper.getStats();
            stats.addMaxWidth(exchange.getMaxReceiveWidth());
            return null;
        }

        @Override
        public Void visitGroupScan(GroupScan groupScan, Wrapper wrapper) {
            Stats stats = wrapper.getStats();
            stats.addMaxWidth(groupScan.getMaxParallelizationWidth());
            return (Void)super.visitGroupScan(groupScan, wrapper);
        }

        @Override
        public Void visitSubScan(SubScan subScan, Wrapper wrapper) throws RuntimeException {
            return this.visitOp((PhysicalOperator)subScan, wrapper);
        }

        @Override
        public Void visitStore(Store store, Wrapper wrapper) {
            Stats stats = wrapper.getStats();
            stats.addMaxWidth(store.getMaxWidth());
            return (Void)super.visitStore(store, wrapper);
        }

        @Override
        public Void visitLimit(Limit limit, Wrapper wrapper) throws RuntimeException {
            return this.visitOp((PhysicalOperator)limit, wrapper);
        }

        @Override
        public Void visitOp(PhysicalOperator op, Wrapper wrapper) {
            if (op instanceof HasAffinity) {
                wrapper.addEndpointAffinity(((HasAffinity)op).getOperatorAffinity());
            }
            Stats stats = wrapper.getStats();
            stats.addCost(op.getCost());
            for (PhysicalOperator child : op) {
                child.accept(this, wrapper);
            }
            return null;
        }

        @Override
        public Void visitWindowFrame(WindowPOP window, Wrapper value) throws RuntimeException {
            return this.visitOp((PhysicalOperator)window, value);
        }
    }
}

