/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanningSet
implements Iterable<Wrapper> {
    static final Logger logger = LoggerFactory.getLogger(PlanningSet.class);
    private Map<Fragment, Wrapper> fragmentMap = Maps.newHashMap();
    private int majorFragmentIdIndex = 0;

    PlanningSet() {
    }

    Wrapper get(Fragment node) {
        Wrapper wrapper = this.fragmentMap.get(node);
        if (wrapper == null) {
            int majorFragmentId = 0;
            if (node.getSendingExchange() != null && (majorFragmentId = node.getSendingExchange().getChild().getOperatorId() >> 16) == 0) {
                majorFragmentId = this.majorFragmentIdIndex;
            }
            wrapper = new Wrapper(node, majorFragmentId);
            this.fragmentMap.put(node, wrapper);
            ++this.majorFragmentIdIndex;
        }
        return wrapper;
    }

    @Override
    public Iterator<Wrapper> iterator() {
        return this.fragmentMap.values().iterator();
    }

    public String toString() {
        return "FragmentPlanningSet:\n" + this.fragmentMap.values() + "]";
    }
}

