/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.physical.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Materializer
extends AbstractPhysicalVisitor<PhysicalOperator, IndexedFragmentNode, ExecutionSetupException> {
    static final Logger logger = LoggerFactory.getLogger(Materializer.class);

    @Override
    public PhysicalOperator visitExchange(Exchange exchange, IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(exchange);
        if (exchange == iNode.getNode().getSendingExchange()) {
            PhysicalOperator child = exchange.getChild().accept(this, iNode);
            Sender materializedSender = exchange.getSender(iNode.getMinorFragmentId(), child);
            materializedSender.setOperatorId(0);
            return materializedSender;
        }
        Receiver materializedReceiver = exchange.getReceiver(iNode.getMinorFragmentId());
        materializedReceiver.setOperatorId(Short.MAX_VALUE & exchange.getOperatorId());
        return materializedReceiver;
    }

    @Override
    public PhysicalOperator visitGroupScan(GroupScan groupScan, IndexedFragmentNode iNode) throws ExecutionSetupException {
        SubScan child = groupScan.getSpecificScan(iNode.getMinorFragmentId());
        child.setOperatorId(Short.MAX_VALUE & groupScan.getOperatorId());
        return child;
    }

    @Override
    public PhysicalOperator visitSubScan(SubScan subScan, IndexedFragmentNode value) throws ExecutionSetupException {
        value.addAllocation(subScan);
        return (PhysicalOperator)super.visitOp((PhysicalOperator)subScan, value);
    }

    @Override
    public PhysicalOperator visitStore(Store store, IndexedFragmentNode iNode) throws ExecutionSetupException {
        PhysicalOperator child = store.getChild().accept(this, iNode);
        iNode.addAllocation(store);
        try {
            Store o = store.getSpecificStore(child, iNode.getMinorFragmentId());
            o.setOperatorId(Short.MAX_VALUE & store.getOperatorId());
            return o;
        }
        catch (PhysicalOperatorSetupException e) {
            throw new FragmentSetupException("Failure while generating a specific Store materialization.");
        }
    }

    @Override
    public PhysicalOperator visitOp(PhysicalOperator op, IndexedFragmentNode iNode) throws ExecutionSetupException {
        iNode.addAllocation(op);
        ArrayList<PhysicalOperator> children = Lists.newArrayList();
        for (PhysicalOperator child : op) {
            children.add(child.accept(this, iNode));
        }
        PhysicalOperator newOp = op.getNewWithChildren(children);
        newOp.setOperatorId(Short.MAX_VALUE & op.getOperatorId());
        return newOp;
    }

    public static class IndexedFragmentNode {
        final Wrapper info;
        final int minorFragmentId;

        public IndexedFragmentNode(int minorFragmentId, Wrapper info) {
            this.info = info;
            this.minorFragmentId = minorFragmentId;
        }

        public Fragment getNode() {
            return this.info.getNode();
        }

        public int getMinorFragmentId() {
            return this.minorFragmentId;
        }

        public void addAllocation(PhysicalOperator pop) {
            this.info.addAllocation(pop);
        }
    }
}

