/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeFragmentsVisitor
extends AbstractPhysicalVisitor<Fragment, Fragment, ForemanSetupException> {
    static final Logger logger = LoggerFactory.getLogger(MakeFragmentsVisitor.class);

    @Override
    public Fragment visitExchange(Exchange exchange, Fragment value) throws ForemanSetupException {
        if (value == null) {
            throw new ForemanSetupException("The simple fragmenter was called without a FragmentBuilder value.  This will only happen if the initial call to SimpleFragmenter is by a Exchange node.  This should never happen since an Exchange node should never be the root node of a plan.");
        }
        Fragment next = this.getNextBuilder();
        value.addReceiveExchange(exchange, next);
        next.addSendExchange(exchange);
        exchange.getChild().accept(this, next);
        return value;
    }

    @Override
    public Fragment visitSubScan(SubScan subScan, Fragment value) throws ForemanSetupException {
        return (Fragment)super.visitOp((PhysicalOperator)subScan, value);
    }

    @Override
    public Fragment visitOp(PhysicalOperator op, Fragment value) throws ForemanSetupException {
        value = this.ensureBuilder(value);
        value.addOperator(op);
        for (PhysicalOperator child : op) {
            child.accept(this, value);
        }
        return value;
    }

    private Fragment ensureBuilder(Fragment value) throws ForemanSetupException {
        if (value != null) {
            return value;
        }
        return this.getNextBuilder();
    }

    public Fragment getNextBuilder() {
        return new Fragment();
    }
}

