/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.fragment.Stats;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fragment
implements Iterable<ExchangeFragmentPair> {
    static final Logger logger = LoggerFactory.getLogger(Fragment.class);
    private PhysicalOperator root;
    private Exchange sendingExchange;
    private final List<ExchangeFragmentPair> receivingExchangePairs = Lists.newLinkedList();
    private Stats stats = new Stats();

    public void addOperator(PhysicalOperator o) {
        if (this.root == null) {
            this.root = o;
        }
    }

    public void addSendExchange(Exchange e) throws ForemanSetupException {
        if (this.sendingExchange != null) {
            throw new ForemanSetupException("Fragment was trying to add a second SendExchange.  ");
        }
        this.addOperator(e);
        this.sendingExchange = e;
    }

    public void addReceiveExchange(Exchange e, Fragment fragment) {
        this.receivingExchangePairs.add(new ExchangeFragmentPair(e, fragment));
    }

    @Override
    public Iterator<ExchangeFragmentPair> iterator() {
        return this.receivingExchangePairs.iterator();
    }

    public List<ExchangeFragmentPair> getReceivingExchangePairs() {
        return this.receivingExchangePairs;
    }

    public PhysicalOperator getRoot() {
        return this.root;
    }

    public Exchange getSendingExchange() {
        return this.sendingExchange;
    }

    public Stats getStats() {
        return this.stats;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.receivingExchangePairs == null ? 0 : this.receivingExchangePairs.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        result = 31 * result + (this.sendingExchange == null ? 0 : this.sendingExchange.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fragment other = (Fragment)obj;
        if (this.receivingExchangePairs == null ? other.receivingExchangePairs != null : !this.receivingExchangePairs.equals(other.receivingExchangePairs)) {
            return false;
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        if (this.sendingExchange == null ? other.sendingExchange != null : !this.sendingExchange.equals(other.sendingExchange)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    public String toString() {
        return "FragmentNode [root=" + this.root + ", sendingExchange=" + this.sendingExchange + ", receivingExchangePairs=" + this.receivingExchangePairs + ", stats=" + this.stats + "]";
    }

    public class ExchangeFragmentPair {
        private Exchange exchange;
        private Fragment node;

        public ExchangeFragmentPair(Exchange exchange, Fragment node) {
            this.exchange = exchange;
            this.node = node;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public Fragment getNode() {
            return this.node;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exchange == null ? 0 : this.exchange.hashCode());
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            return result;
        }

        public String toString() {
            return "ExchangeFragmentPair [exchange=" + this.exchange + "]";
        }
    }
}

