/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Pair;

public abstract class DrillRelOptUtil {
    public static boolean areRowTypesEqual(RelDataType rowType1, RelDataType rowType2, boolean compareNames, boolean allowSubstring) {
        if (rowType1 == rowType2) {
            return true;
        }
        if (compareNames) {
            return false;
        }
        if (rowType2.getFieldCount() != rowType1.getFieldCount()) {
            return false;
        }
        List<RelDataTypeField> f1 = rowType1.getFieldList();
        List<RelDataTypeField> f2 = rowType2.getFieldList();
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(f1, f2)) {
            RelDataType type1 = ((RelDataTypeField)pair.left).getType();
            RelDataType type2 = ((RelDataTypeField)pair.right).getType();
            if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY || type1.equals(type2)) continue;
            return allowSubstring && type1.getSqlTypeName() == SqlTypeName.CHAR && type2.getSqlTypeName() == SqlTypeName.CHAR && type1.getPrecision() <= type2.getPrecision();
        }
        return true;
    }
}

