/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;

public abstract class DrillJoinRelBase
extends JoinRelBase
implements DrillRelNode {
    protected List<Integer> leftKeys = Lists.newArrayList();
    protected List<Integer> rightKeys = Lists.newArrayList();
    private final double joinRowFactor;

    public DrillJoinRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, Collections.emptySet());
        this.joinRowFactor = PrelUtil.getPlannerSettings(cluster.getPlanner()).getRowCountEstimateFactor();
    }

    @Override
    public double getRows() {
        return this.joinRowFactor * Math.max(this.getLeft().getRows(), this.getRight().getRows());
    }

    protected boolean uniqueFieldNames(RelDataType rowType) {
        return DrillJoinRelBase.isUnique(rowType.getFieldNames());
    }

    protected static <T> boolean isUnique(List<T> list) {
        return new HashSet<T>(list).size() == list.size();
    }

    public List<Integer> getLeftKeys() {
        return this.leftKeys;
    }

    public List<Integer> getRightKeys() {
        return this.rightKeys;
    }
}

