/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import org.apache.drill.exec.planner.PartitionDescriptor;

public class FileSystemPartitionDescriptor
implements PartitionDescriptor {
    private final String partitionLabel;
    private final int partitionLabelLength;

    public FileSystemPartitionDescriptor(String partitionLabel) {
        this.partitionLabel = partitionLabel;
        this.partitionLabelLength = partitionLabel.length();
    }

    @Override
    public int getPartitionHierarchyIndex(String partitionName) {
        String suffix = partitionName.substring(this.partitionLabelLength);
        return Integer.parseInt(suffix);
    }

    @Override
    public boolean isPartitionName(String name) {
        return name.matches(this.partitionLabel + "[0-9]");
    }

    @Override
    public int getMaxHierarchyLevel() {
        return 10;
    }
}

