/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.IteratorValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorValidatorInjector
extends AbstractPhysicalVisitor<PhysicalOperator, FragmentContext, ExecutionSetupException> {
    static final Logger logger = LoggerFactory.getLogger(IteratorValidatorInjector.class);

    public static FragmentRoot rewritePlanWithIteratorValidator(FragmentContext context, FragmentRoot root) throws ExecutionSetupException {
        IteratorValidatorInjector inject = new IteratorValidatorInjector();
        PhysicalOperator newOp = root.accept(inject, context);
        if (!(newOp instanceof FragmentRoot)) {
            throw new IllegalStateException("This shouldn't happen.");
        }
        return (FragmentRoot)newOp;
    }

    @Override
    public PhysicalOperator visitOp(PhysicalOperator op, FragmentContext context) throws ExecutionSetupException {
        ArrayList<PhysicalOperator> newChildren = Lists.newArrayList();
        PhysicalOperator newOp = op;
        for (PhysicalOperator child : op) {
            IteratorValidator validator = new IteratorValidator(child.accept(this, context));
            validator.setOperatorId(op.getOperatorId() + 1000);
            newChildren.add(validator);
        }
        if (newChildren.size() > 0) {
            newOp = op.getNewWithChildren(newChildren);
            newOp.setOperatorId(op.getOperatorId());
        }
        return newOp;
    }
}

